/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.OracleByteVectorJdbcType;
import org.hibernate.vector.OracleDoubleVectorJdbcType;
import org.hibernate.vector.OracleFloatVectorJdbcType;
import org.hibernate.vector.OracleVectorJdbcType;

public class OracleVectorTypeContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        Dialect dialect = ((JdbcServices)serviceRegistry.requireService(JdbcServices.class)).getDialect();
        if (dialect instanceof OracleDialect && dialect.getVersion().isSameOrAfter(23, 4)) {
            TypeConfiguration typeConfiguration = typeContributions.getTypeConfiguration();
            JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
            JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
            BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
            boolean isVectorSupported = this.isVectorSupportedByDriver((OracleDialect)dialect);
            OracleVectorJdbcType genericVectorJdbcType = new OracleVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10000, (JdbcType)genericVectorJdbcType);
            OracleFloatVectorJdbcType floatVectorJdbcType = new OracleFloatVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10002, (JdbcType)floatVectorJdbcType);
            OracleDoubleVectorJdbcType doubleVectorJdbcType = new OracleDoubleVectorJdbcType(jdbcTypeRegistry.getDescriptor(8), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10003, (JdbcType)doubleVectorJdbcType);
            OracleByteVectorJdbcType byteVectorJdbcType = new OracleByteVectorJdbcType(jdbcTypeRegistry.getDescriptor(-6), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10001, (JdbcType)byteVectorJdbcType);
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)genericVectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)floatVectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR_FLOAT32.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE), (JdbcType)doubleVectorJdbcType, javaTypeRegistry.getDescriptor(double[].class)), StandardBasicTypes.VECTOR_FLOAT64.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.BYTE), (JdbcType)byteVectorJdbcType, javaTypeRegistry.getDescriptor(byte[].class)), StandardBasicTypes.VECTOR_INT8.getName());
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new DdlTypeImpl(10000, "vector($l, *)", "vector", dialect){

                public String getTypeName(Size size) {
                    return OracleVectorTypeContributor.replace("vector($l, *)", size.getArrayLength() == null ? null : Long.valueOf(size.getArrayLength().longValue()));
                }
            });
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new DdlTypeImpl(10001, "vector($l, INT8)", "vector", dialect){

                public String getTypeName(Size size) {
                    return OracleVectorTypeContributor.replace("vector($l, INT8)", size.getArrayLength() == null ? null : Long.valueOf(size.getArrayLength().longValue()));
                }
            });
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new DdlTypeImpl(10002, "vector($l, FLOAT32)", "vector", dialect){

                public String getTypeName(Size size) {
                    return OracleVectorTypeContributor.replace("vector($l, FLOAT32)", size.getArrayLength() == null ? null : Long.valueOf(size.getArrayLength().longValue()));
                }
            });
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new DdlTypeImpl(10003, "vector($l, FLOAT64)", "vector", dialect){

                public String getTypeName(Size size) {
                    return OracleVectorTypeContributor.replace("vector($l, FLOAT64)", size.getArrayLength() == null ? null : Long.valueOf(size.getArrayLength().longValue()));
                }
            });
        }
    }

    private static String replace(String type, Long size) {
        return StringHelper.replaceOnce((String)type, (String)"$l", (String)(size != null ? size.toString() : "*"));
    }

    private boolean isVectorSupportedByDriver(OracleDialect dialect) {
        int majorVersion = dialect.getDriverMajorVersion();
        int minorVersion = dialect.getDriverMinorVersion();
        return majorVersion > 23 || majorVersion == 23 && minorVersion >= 4;
    }
}

