/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import java.util.Arrays;
import java.util.BitSet;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.AbstractOracleVectorJdbcType;

public class OracleFloatVectorJdbcType
extends AbstractOracleVectorJdbcType {
    private static final float[] EMPTY = new float[0];

    public OracleFloatVectorJdbcType(JdbcType elementJdbcType, boolean isVectorSupported) {
        super(elementJdbcType, isVectorSupported);
    }

    @Override
    public void appendWriteExpression(String writeExpression, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"to_vector(");
        appender.append((CharSequence)writeExpression);
        appender.append((CharSequence)", *, FLOAT32)");
    }

    public String getFriendlyName() {
        return "VECTOR_FLOAT32";
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 10002;
    }

    protected float[] getVectorArray(String string) {
        int commaIndex;
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return EMPTY;
        }
        BitSet commaPositions = new BitSet();
        int size = 1;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ',') continue;
            commaPositions.set(i);
            ++size;
        }
        float[] result = new float[size];
        int doubleStartIndex = 1;
        int index = 0;
        while ((commaIndex = commaPositions.nextSetBit(doubleStartIndex)) != -1) {
            result[index++] = Float.parseFloat(string.substring(doubleStartIndex, commaIndex));
            doubleStartIndex = commaIndex + 1;
        }
        result[index] = Float.parseFloat(string.substring(doubleStartIndex, string.length() - 1));
        return result;
    }

    @Override
    protected <T> String getStringVector(T vector, JavaType<T> javaTypeDescriptor, WrapperOptions options) {
        return Arrays.toString((float[])javaTypeDescriptor.unwrap(vector, float[].class, options));
    }

    @Override
    protected Class<?> getNativeJavaType() {
        return float[].class;
    }

    @Override
    protected int getNativeTypeCode() {
        return -107;
    }
}

