/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import java.util.Arrays;
import java.util.BitSet;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.AbstractOracleVectorJdbcType;

public class OracleByteVectorJdbcType
extends AbstractOracleVectorJdbcType {
    private static final byte[] EMPTY = new byte[0];

    public OracleByteVectorJdbcType(JdbcType elementJdbcType, boolean isVectorSupported) {
        super(elementJdbcType, isVectorSupported);
    }

    @Override
    public void appendWriteExpression(String writeExpression, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"to_vector(");
        appender.append((CharSequence)writeExpression);
        appender.append((CharSequence)", *, INT8)");
    }

    public String getFriendlyName() {
        return "VECTOR_INT8";
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 10001;
    }

    protected byte[] getVectorArray(String string) {
        int commaIndex;
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return EMPTY;
        }
        BitSet commaPositions = new BitSet();
        int size = 1;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ',') continue;
            commaPositions.set(i);
            ++size;
        }
        byte[] result = new byte[size];
        int doubleStartIndex = 1;
        int index = 0;
        while ((commaIndex = commaPositions.nextSetBit(doubleStartIndex)) != -1) {
            result[index++] = Byte.parseByte(string.substring(doubleStartIndex, commaIndex));
            doubleStartIndex = commaIndex + 1;
        }
        result[index] = Byte.parseByte(string.substring(doubleStartIndex, string.length() - 1));
        return result;
    }

    @Override
    protected <T> String getStringVector(T vector, JavaType<T> javaTypeDescriptor, WrapperOptions options) {
        return Arrays.toString((byte[])javaTypeDescriptor.unwrap(vector, byte[].class, options));
    }

    @Override
    protected Class<?> getNativeJavaType() {
        return byte[].class;
    }

    @Override
    protected int getNativeTypeCode() {
        return -106;
    }
}

