/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import java.util.List;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BindingContext;

public class VectorArgumentValidator
implements ArgumentsValidator {
    public static final ArgumentsValidator INSTANCE = new VectorArgumentValidator();

    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
        for (int i = 0; i < arguments.size(); ++i) {
            SqmDomainType type;
            SqmBindableType expressible = arguments.get(i).getExpressible();
            if (expressible == null || (type = expressible.getSqmType()) == null || VectorArgumentValidator.isVectorType(type)) continue;
            throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' requires a vector type, but argument is of type '%s'", i, functionName, type.getTypeName()));
        }
    }

    private static boolean isVectorType(SqmExpressible<?> vectorType) {
        boolean bl;
        block4: {
            block3: {
                if (!(vectorType instanceof BasicPluralType)) break block3;
                BasicPluralType basicPluralType = (BasicPluralType)vectorType;
                switch (basicPluralType.getJdbcType().getDefaultSqlTypeCode()) {
                    case 10000: 
                    case 10001: 
                    case 10002: 
                    case 10003: {
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }
}

