/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.util.uuid;

import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Value;
import org.hibernate.service.ServiceRegistry;

public class IdGeneratorCreationContext
implements GeneratorCreationContext {
    private final ServiceRegistry serviceRegistry;
    private final MetadataImplementor domainModel;
    private final RootClass entityMapping;
    private final KeyValue identifier;

    public IdGeneratorCreationContext(ServiceRegistry serviceRegistry, MetadataImplementor domainModel, RootClass entityMapping) {
        this.serviceRegistry = serviceRegistry;
        this.domainModel = domainModel;
        this.entityMapping = entityMapping;
        this.identifier = entityMapping.getIdentifier();
        assert (entityMapping.getIdentifierProperty() != null);
    }

    public IdGeneratorCreationContext(MetadataImplementor domainModel, RootClass entityMapping) {
        this((ServiceRegistry)domainModel.getMetadataBuildingOptions().getServiceRegistry(), domainModel, entityMapping);
    }

    public RootClass getRootClass() {
        return this.entityMapping;
    }

    public Database getDatabase() {
        return this.domainModel.getDatabase();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public String getDefaultCatalog() {
        return "";
    }

    public String getDefaultSchema() {
        return "";
    }

    public PersistentClass getPersistentClass() {
        return this.entityMapping;
    }

    public Property getProperty() {
        return this.entityMapping.getIdentifierProperty();
    }

    public Value getValue() {
        return this.identifier;
    }
}

