/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.util.ast;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class LoadingAstHelper {
    public static <I> LoaderTranslation translateLoading(EntityMappingType entityMappingType, I id, SessionFactoryImplementor sessionFactory) {
        return LoadingAstHelper.translateLoading(entityMappingType, List.of(id), sessionFactory);
    }

    public static <I> LoaderTranslation translateLoading(EntityMappingType entityMappingType, List<I> ids, SessionFactoryImplementor sessionFactory) {
        ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)entityMappingType, null, (ModelPart)entityMappingType.getIdentifierMapping(), null, (int)ids.size(), (LoadQueryInfluencers)new LoadQueryInfluencers(sessionFactory), (LockOptions)LockOptions.NONE, jdbcParameters::add, (SessionFactoryImplementor)sessionFactory);
        SqlAstTranslator sqlAstTranslator = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, sqlAst);
        JdbcOperationQuerySelect jdbcOperation = (JdbcOperationQuerySelect)sqlAstTranslator.translate(LoadingAstHelper.buildJdbcParameterBindings(entityMappingType.getIdentifierMapping(), ids, jdbcParameters), QueryOptions.NONE);
        return new LoaderTranslation(jdbcOperation.getSqlString(), sqlAst, jdbcParameters);
    }

    private static <I> JdbcParameterBindings buildJdbcParameterBindings(EntityIdentifierMapping identifierMapping, List<I> ids, ArrayList<JdbcParameter> jdbcParameters) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        identifierMapping.forEachJdbcType((arg_0, arg_1) -> LoadingAstHelper.lambda$buildJdbcParameterBindings$0((JdbcParameterBindings)jdbcParameterBindings, jdbcParameters, arg_0, arg_1));
        return jdbcParameterBindings;
    }

    private static /* synthetic */ void lambda$buildJdbcParameterBindings$0(JdbcParameterBindings jdbcParameterBindings, ArrayList jdbcParameters, int position, JdbcMapping jdbcMapping) {
        jdbcParameterBindings.addBinding((JdbcParameter)jdbcParameters.get(position), (JdbcParameterBinding)new JdbcParameterBindingImpl(jdbcMapping, null));
    }

    public record LoaderTranslation(String sql, SelectStatement sqlAst, List<JdbcParameter> jdbcParameters) {
    }
}

