/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.util.ast;

import java.util.Map;
import org.hibernate.Session;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcOperationQueryDelete;
import org.hibernate.sql.exec.internal.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.internal.JdbcOperationQueryUpdate;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class HqlHelper {
    public static HqlTranslation translateHql(String hql, SessionFactoryImplementor sessionFactory) {
        return HqlHelper.translateHql(hql, Object[].class, sessionFactory);
    }

    public static HqlTranslation translateHql(String hql, Class<?> resultType, SessionFactoryImplementor sessionFactory) {
        HqlTranslator hqlTranslator = sessionFactory.getQueryEngine().getHqlTranslator();
        SqmStatement sqmAst = hqlTranslator.translate(hql, resultType);
        if (sqmAst instanceof SqmSelectStatement) {
            SqmSelectStatement sqmSelect = (SqmSelectStatement)sqmAst;
            return new SqmSelectInterpreter(hql, sessionFactory).interpret(sqmSelect, sessionFactory);
        }
        if (sqmAst instanceof SqmDeleteStatement) {
            SqmDeleteStatement sqmDelete = (SqmDeleteStatement)sqmAst;
            return new SqmDeleteInterpreter(hql, sessionFactory).interpret(sqmDelete, sessionFactory);
        }
        if (sqmAst instanceof SqmUpdateStatement) {
            SqmUpdateStatement sqmUpdate = (SqmUpdateStatement)sqmAst;
            return new SqmUpdateInterpreter(hql, sessionFactory).interpret(sqmUpdate, sessionFactory);
        }
        if (sqmAst instanceof SqmInsertStatement) {
            SqmInsertStatement sqmInsert = (SqmInsertStatement)sqmAst;
            return new SqmInsertInterpreter(hql, sessionFactory).interpret(sqmInsert, sessionFactory);
        }
        throw new UnsupportedOperationException("Unexpected SQM type from HQL - " + sqmAst.getClass().getName());
    }

    public record HqlTranslation(String hql, SqmStatement<?> sqm, String sql, Statement sqlAst, ParameterMetadata parameterMetadata) {
    }

    private static class SqmSelectInterpreter<R>
    extends SqmInterpreter<R, SqmSelectStatement<R>, SelectStatement, JdbcOperationQuerySelect> {
        public SqmSelectInterpreter(String hql, SessionFactoryImplementor sessionFactory) {
            super(hql, sessionFactory);
        }

        @Override
        protected SqmTranslator<SelectStatement> createSqmTranslator(HqlInterpretation<R> hqlInterpretation, QueryParameterBindingsImpl parameterBindings) {
            SqmTranslatorFactory sqmTranslatorFactory = this.sessionFactory.getQueryEngine().getSqmTranslatorFactory();
            return sqmTranslatorFactory.createSelectTranslator((SqmSelectStatement)hqlInterpretation.getSqmStatement(), QueryOptions.NONE, hqlInterpretation.getDomainParameterXref(), (QueryParameterBindings)parameterBindings, new LoadQueryInfluencers(this.sessionFactory), (SqlAstCreationContext)this.sessionFactory.getSqlTranslationEngine(), true);
        }

        @Override
        protected SqlAstTranslator<JdbcOperationQuerySelect> createSqlAstTranslator(SqmTranslation<SelectStatement> sqmTranslation) {
            SqlAstTranslatorFactory sqlAstTranslatorFactory = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
            return sqlAstTranslatorFactory.buildSelectTranslator(this.sessionFactory, (SelectStatement)sqmTranslation.getSqlAst());
        }
    }

    private static class SqmDeleteInterpreter<R>
    extends SqmInterpreter<R, SqmDeleteStatement<R>, DeleteStatement, JdbcOperationQueryDelete> {
        public SqmDeleteInterpreter(String hql, SessionFactoryImplementor sessionFactory) {
            super(hql, sessionFactory);
        }

        @Override
        protected SqmTranslator<DeleteStatement> createSqmTranslator(HqlInterpretation<R> hqlInterpretation, QueryParameterBindingsImpl parameterBindings) {
            SqmTranslatorFactory sqmTranslatorFactory = this.sessionFactory.getQueryEngine().getSqmTranslatorFactory();
            return sqmTranslatorFactory.createMutationTranslator((SqmDmlStatement)((SqmDeleteStatement)hqlInterpretation.getSqmStatement()), QueryOptions.NONE, hqlInterpretation.getDomainParameterXref(), (QueryParameterBindings)parameterBindings, new LoadQueryInfluencers(this.sessionFactory), (SqlAstCreationContext)this.sessionFactory.getSqlTranslationEngine());
        }

        @Override
        protected SqlAstTranslator<JdbcOperationQueryDelete> createSqlAstTranslator(SqmTranslation<DeleteStatement> sqmTranslation) {
            SqlAstTranslatorFactory sqlAstTranslatorFactory = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
            return sqlAstTranslatorFactory.buildMutationTranslator(this.sessionFactory, (MutationStatement)sqmTranslation.getSqlAst());
        }
    }

    private static class SqmUpdateInterpreter<R>
    extends SqmInterpreter<R, SqmUpdateStatement<R>, UpdateStatement, JdbcOperationQueryUpdate> {
        public SqmUpdateInterpreter(String hql, SessionFactoryImplementor sessionFactory) {
            super(hql, sessionFactory);
        }

        @Override
        protected SqmTranslator<UpdateStatement> createSqmTranslator(HqlInterpretation<R> hqlInterpretation, QueryParameterBindingsImpl parameterBindings) {
            SqmTranslatorFactory sqmTranslatorFactory = this.sessionFactory.getQueryEngine().getSqmTranslatorFactory();
            return sqmTranslatorFactory.createMutationTranslator((SqmDmlStatement)((SqmUpdateStatement)hqlInterpretation.getSqmStatement()), QueryOptions.NONE, hqlInterpretation.getDomainParameterXref(), (QueryParameterBindings)parameterBindings, new LoadQueryInfluencers(this.sessionFactory), (SqlAstCreationContext)this.sessionFactory.getSqlTranslationEngine());
        }

        @Override
        protected SqlAstTranslator<JdbcOperationQueryUpdate> createSqlAstTranslator(SqmTranslation<UpdateStatement> sqmTranslation) {
            SqlAstTranslatorFactory sqlAstTranslatorFactory = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
            return sqlAstTranslatorFactory.buildMutationTranslator(this.sessionFactory, (MutationStatement)sqmTranslation.getSqlAst());
        }
    }

    private static class SqmInsertInterpreter<R>
    extends SqmInterpreter<R, SqmInsertStatement<R>, InsertStatement, JdbcOperationQueryInsert> {
        public SqmInsertInterpreter(String hql, SessionFactoryImplementor sessionFactory) {
            super(hql, sessionFactory);
        }

        @Override
        protected SqmTranslator<InsertStatement> createSqmTranslator(HqlInterpretation<R> hqlInterpretation, QueryParameterBindingsImpl parameterBindings) {
            SqmTranslatorFactory sqmTranslatorFactory = this.sessionFactory.getQueryEngine().getSqmTranslatorFactory();
            return sqmTranslatorFactory.createMutationTranslator((SqmDmlStatement)((SqmInsertStatement)hqlInterpretation.getSqmStatement()), QueryOptions.NONE, hqlInterpretation.getDomainParameterXref(), (QueryParameterBindings)parameterBindings, new LoadQueryInfluencers(this.sessionFactory), (SqlAstCreationContext)this.sessionFactory.getSqlTranslationEngine());
        }

        @Override
        protected SqlAstTranslator<JdbcOperationQueryInsert> createSqlAstTranslator(SqmTranslation<InsertStatement> sqmTranslation) {
            SqlAstTranslatorFactory sqlAstTranslatorFactory = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
            return sqlAstTranslatorFactory.buildMutationTranslator(this.sessionFactory, (MutationStatement)sqmTranslation.getSqlAst());
        }
    }

    private record NonCopyingHqlInterpretationImpl<R>(SqmStatement<R> sqmAst, ParameterMetadataImplementor parameterMetadata, DomainParameterXref domainParameterXref) implements HqlInterpretation<R>
    {
        public SqmStatement<R> getSqmStatement() {
            return this.sqmAst();
        }

        public ParameterMetadataImplementor getParameterMetadata() {
            return this.parameterMetadata();
        }

        public DomainParameterXref getDomainParameterXref() {
            return this.domainParameterXref();
        }

        public void validateResultType(Class<?> resultType) {
        }
    }

    private static abstract class SqmInterpreter<R, T extends SqmStatement<R>, S extends Statement, J extends JdbcOperation> {
        protected final String hql;
        protected final SessionFactoryImplementor sessionFactory;

        public SqmInterpreter(String hql, SessionFactoryImplementor sessionFactory) {
            this.hql = hql;
            this.sessionFactory = sessionFactory;
        }

        public HqlTranslation interpret(T sqmAst, SessionFactoryImplementor sessionFactory) {
            HqlInterpretation<R> hqlInterpretation = this.createHqlInterpretation(sqmAst);
            QueryParameterBindingsImpl domainParameterBindings = QueryParameterBindingsImpl.from((ParameterMetadataImplementor)hqlInterpretation.getParameterMetadata(), (SessionFactoryImplementor)sessionFactory);
            SqmTranslator<S> sqmTranslator = this.createSqmTranslator(hqlInterpretation, domainParameterBindings);
            SqmTranslation sqmTranslation = sqmTranslator.translate();
            SqlAstTranslator<J> sqlAstTranslator = this.createSqlAstTranslator(sqmTranslation);
            JdbcOperation jdbcOperation = (JdbcOperation)sessionFactory.fromSession(session -> {
                JdbcParameterBindings jdbcParameterBindings = this.createJdbcParameterBindings((SqmTranslation<S>)sqmTranslation, hqlInterpretation.getDomainParameterXref(), domainParameterBindings, (Session)session);
                return sqlAstTranslator.translate(jdbcParameterBindings, QueryOptions.NONE);
            });
            return new HqlTranslation(this.hql, hqlInterpretation.getSqmStatement(), jdbcOperation.getSqlString(), sqmTranslation.getSqlAst(), (ParameterMetadata)hqlInterpretation.getParameterMetadata());
        }

        private HqlInterpretation<R> createHqlInterpretation(T sqmAst) {
            ParameterMetadataImpl parameterMetadata;
            DomainParameterXref domainParameterXref;
            if (sqmAst.getSqmParameters().isEmpty()) {
                domainParameterXref = DomainParameterXref.EMPTY;
                parameterMetadata = ParameterMetadataImpl.EMPTY;
            } else {
                domainParameterXref = DomainParameterXref.from(sqmAst);
                parameterMetadata = new ParameterMetadataImpl(domainParameterXref.getQueryParameters());
            }
            return new NonCopyingHqlInterpretationImpl(sqmAst, (ParameterMetadataImplementor)parameterMetadata, domainParameterXref);
        }

        protected abstract SqmTranslator<S> createSqmTranslator(HqlInterpretation<R> var1, QueryParameterBindingsImpl var2);

        protected abstract SqlAstTranslator<J> createSqlAstTranslator(SqmTranslation<S> var1);

        private JdbcParameterBindings createJdbcParameterBindings(SqmTranslation<S> sqmTranslation, final DomainParameterXref domainParameterXref, final QueryParameterBindingsImpl parameterBindings, Session session) {
            return SqmUtil.createJdbcParameterBindings((QueryParameterBindings)parameterBindings, (DomainParameterXref)domainParameterXref, (Map)SqmUtil.generateJdbcParamsXref((DomainParameterXref)domainParameterXref, () -> sqmTranslation.getJdbcParamsBySqmParam()), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){
                final /* synthetic */ SqmInterpreter this$0;
                {
                    this.this$0 = this$0;
                }

                public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                    QueryParameterImplementor domainParam = domainParameterXref.getQueryParameter(parameter);
                    QueryParameterBinding binding = parameterBindings.getBinding(domainParam);
                    return binding.getType();
                }
            }, (SharedSessionContractImplementor)((SharedSessionContractImplementor)session.unwrap(SharedSessionContractImplementor.class)));
        }
    }
}

