/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.jpa.HibernatePersistenceConfiguration;
import org.hibernate.service.Service;

public interface ServiceRegistryScope {
    public static void using(Supplier<StandardServiceRegistry> ssrProducer, Consumer<ServiceRegistryScope> action) {
        try (final StandardServiceRegistry ssr = ssrProducer.get();){
            action.accept(new ServiceRegistryScope(){

                @Override
                public StandardServiceRegistry getRegistry() {
                    return ssr;
                }

                @Override
                public void releaseRegistry() {
                    ssr.close();
                }
            });
        }
    }

    public StandardServiceRegistry getRegistry();

    public void releaseRegistry();

    default public <S extends Service> void withService(Class<S> role, Consumer<S> action) {
        if (!2.$assertionsDisabled && role == null) {
            throw new AssertionError();
        }
        Service service = this.getRegistry().getService(role);
        if (service == null) {
            throw new IllegalArgumentException("Could not locate requested service - " + role.getName());
        }
        action.accept(service);
    }

    default public <R, S extends Service> R fromService(Class<S> role, Function<S, R> action) {
        if (!2.$assertionsDisabled && role == null) {
            throw new AssertionError();
        }
        Service service = this.getRegistry().getService(role);
        if (service == null) {
            throw new IllegalArgumentException("Could not locate requested service - " + role.getName());
        }
        return action.apply(service);
    }

    default public HibernatePersistenceConfiguration createPersistenceConfiguration(String persistenceUnitName) {
        HibernatePersistenceConfiguration configuration = new HibernatePersistenceConfiguration(persistenceUnitName);
        StandardServiceRegistry registry = this.getRegistry();
        ConfigurationService configurationService = (ConfigurationService)registry.requireService(ConfigurationService.class);
        configuration.properties(configurationService.getSettings());
        return configuration;
    }

    default public Map<String, Object> getAdditionalSettings() {
        throw new UnsupportedOperationException("This service registry scope doesn't support additional settings.");
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

