/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.testing.orm.junit.Logger;
import org.hibernate.testing.orm.junit.LoggingInspections;
import org.hibernate.testing.orm.junit.MessageKeyWatcher;
import org.hibernate.testing.orm.junit.MessageKeyWatcherImpl;
import org.junit.jupiter.api.extension.ExtensionContext;

public class LoggingInspectionsScope {
    private final Map<String, Map<String, MessageKeyWatcherImpl>> watcherMap = new HashMap<String, Map<String, MessageKeyWatcherImpl>>();

    public LoggingInspectionsScope(LoggingInspections loggingInspections, ExtensionContext context) {
        for (int i = 0; i < loggingInspections.messages().length; ++i) {
            Map<String, MessageKeyWatcherImpl> messageKeyWatcherMap;
            LoggingInspections.Message message = loggingInspections.messages()[i];
            String messageKey = message.messageKey().trim();
            assert (!messageKey.isEmpty());
            if (message.loggers().length == 0) {
                return;
            }
            Map<String, MessageKeyWatcherImpl> existingMessageKeyWatcherMap = this.watcherMap.get(messageKey);
            if (existingMessageKeyWatcherMap != null) {
                messageKeyWatcherMap = existingMessageKeyWatcherMap;
            } else {
                messageKeyWatcherMap = new HashMap<String, MessageKeyWatcherImpl>();
                this.watcherMap.put(messageKey, messageKeyWatcherMap);
            }
            for (Logger logger : message.loggers()) {
                MessageKeyWatcherImpl watcher;
                String loggerKey = MessageKeyWatcherImpl.loggerKey(logger);
                MessageKeyWatcherImpl existingWatcher = messageKeyWatcherMap.get(loggerKey);
                if (existingWatcher != null) {
                    watcher = existingWatcher;
                } else {
                    watcher = new MessageKeyWatcherImpl(messageKey, message.resetBeforeEach());
                    messageKeyWatcherMap.put(loggerKey, watcher);
                }
                watcher.addLogger(logger);
            }
        }
    }

    public void resetWatchers() {
        this.watcherMap.forEach((messageKey, loggerMap) -> loggerMap.forEach((logger, watcher) -> {
            if (watcher.isResetBeforeEach()) {
                watcher.reset();
            }
        }));
    }

    public MessageKeyWatcher getWatcher(String messageKey, String loggerName) {
        Map<String, MessageKeyWatcherImpl> messageKeyWatcherMap = this.watcherMap.get(messageKey);
        return messageKeyWatcherMap.get(loggerName);
    }

    public MessageKeyWatcher getWatcher(String messageKey, Class<?> loggerNameClass) {
        Map<String, MessageKeyWatcherImpl> messageKeyWatcherMap = this.watcherMap.get(messageKey);
        return messageKeyWatcherMap.get(loggerNameClass.getName());
    }

    public boolean wereAnyTriggered() {
        for (Map.Entry<String, Map<String, MessageKeyWatcherImpl>> watcherMapEntry : this.watcherMap.entrySet()) {
            for (Map.Entry<String, MessageKeyWatcherImpl> messageWatcherEntry : watcherMapEntry.getValue().entrySet()) {
                if (!messageWatcherEntry.getValue().wasTriggered()) continue;
                return true;
            }
        }
        return false;
    }
}

