/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.spi.ClassTransformer;
import org.hibernate.cfg.Environment;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.testing.orm.junit.EntityManagerFactoryProducer;
import org.hibernate.testing.orm.junit.EntityManagerFactoryScope;
import org.hibernate.testing.orm.junit.EntityManagerFactoryScopeContainer;
import org.hibernate.testing.orm.junit.FunctionalEntityManagerFactoryTesting;
import org.hibernate.testing.transaction.TransactionUtil;
import org.hibernate.testing.util.ServiceRegistryUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;

@FunctionalEntityManagerFactoryTesting
public class EntityManagerFactoryBasedFunctionalTest
implements EntityManagerFactoryProducer,
EntityManagerFactoryScopeContainer {
    private EntityManagerFactoryScope entityManagerFactoryScope;
    protected static final String[] NO_MAPPINGS = new String[0];
    protected static final Class<?>[] NO_CLASSES = new Class[0];

    @Override
    public EntityManagerFactory produceEntityManagerFactory() {
        EntityManagerFactory entityManagerFactory = Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)this.buildPersistenceUnitDescriptor(), this.buildSettings()).build();
        this.entityManagerFactoryBuilt(entityManagerFactory);
        return entityManagerFactory;
    }

    @Override
    public void injectEntityManagerFactoryScope(EntityManagerFactoryScope scope) {
        this.entityManagerFactoryScope = scope;
    }

    @Override
    public EntityManagerFactoryProducer getEntityManagerFactoryProducer() {
        return this;
    }

    protected EntityManagerFactoryScope entityManagerFactoryScope() {
        return this.entityManagerFactoryScope;
    }

    protected EntityManagerFactory entityManagerFactory() {
        return this.entityManagerFactoryScope.getEntityManagerFactory();
    }

    protected void entityManagerFactoryBuilt(EntityManagerFactory factory) {
    }

    protected boolean strictJpaCompliance() {
        return false;
    }

    protected boolean exportSchema() {
        return true;
    }

    protected String[] getMappings() {
        return NO_MAPPINGS;
    }

    protected void addConfigOptions(Map options) {
    }

    protected Class<?>[] getAnnotatedClasses() {
        return NO_CLASSES;
    }

    protected Map<Object, Object> buildSettings() {
        Map<Object, Object> settings = this.getConfig();
        this.applySettings(settings);
        if (this.exportSchema()) {
            settings.put("hibernate.hbm2ddl.auto", "create-drop");
        }
        return settings;
    }

    @AfterAll
    public void afterAll() {
        if (this.entityManagerFactoryScope != null) {
            try {
                this.entityManagerFactoryScope.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Map<Object, Object> getConfig() {
        Properties config = Environment.getProperties();
        ArrayList classes = new ArrayList();
        classes.addAll(Arrays.asList(this.getAnnotatedClasses()));
        config.put("hibernate.loaded_classes", classes);
        for (Map.Entry<Class, String> entry : this.getCachedClasses().entrySet()) {
            config.put("hibernate.classcache." + entry.getKey().getName(), entry.getValue());
        }
        for (Map.Entry<Object, String> entry : this.getCachedCollections().entrySet()) {
            config.put("hibernate.collectioncache." + (String)entry.getKey(), entry.getValue());
        }
        if (this.getEjb3DD().length > 0) {
            ArrayList<String> dds = new ArrayList<String>();
            dds.addAll(Arrays.asList(this.getEjb3DD()));
            config.put("hibernate.orm_xml_files", dds);
        }
        config.put("hibernate.query.mutation_strategy.persistent.drop_tables", "true");
        config.put("hibernate.query.mutation_strategy.global_temporary.drop_tables", "true");
        config.put("hibernate.query.mutation_strategy.local_temporary.drop_tables", "true");
        ServiceRegistryUtil.applySettings(config);
        this.addConfigOptions(config);
        return config;
    }

    protected void applySettings(Map<Object, Object> settings) {
        CharSequence[] mappings = this.getMappings();
        if (mappings != null) {
            settings.put("hibernate.hbm_xml_files", String.join((CharSequence)",", mappings));
        }
    }

    public Map<Class, String> getCachedClasses() {
        return new HashMap<Class, String>();
    }

    public Map<String, String> getCachedCollections() {
        return new HashMap<String, String>();
    }

    public String[] getEjb3DD() {
        return new String[0];
    }

    protected PersistenceUnitDescriptor buildPersistenceUnitDescriptor() {
        return new TestingPersistenceUnitDescriptorImpl(this.getClass().getSimpleName());
    }

    @AfterEach
    public final void afterTest() {
        if (this.isCleanupTestDataRequired()) {
            this.cleanupTestData();
        }
    }

    protected boolean isCleanupTestDataRequired() {
        return false;
    }

    protected void cleanupTestData() {
        TransactionUtil.doInJPA(this::entityManagerFactory, entityManager -> Arrays.stream(this.getAnnotatedClasses()).forEach(annotatedClass -> entityManager.createQuery("delete from " + annotatedClass.getSimpleName()).executeUpdate()));
    }

    protected void inTransaction(Consumer<EntityManager> action) {
        this.entityManagerFactoryScope().inTransaction(action);
    }

    protected <T> T fromTransaction(Function<EntityManager, T> action) {
        return this.entityManagerFactoryScope().fromTransaction(action);
    }

    protected void inEntityManager(Consumer<EntityManager> action) {
        this.entityManagerFactoryScope().inEntityManager(action);
    }

    protected <T> T fromEntityManager(Function<EntityManager, T> action) {
        return this.entityManagerFactoryScope().fromEntityManager(action);
    }

    public static class TestingPersistenceUnitDescriptorImpl
    implements PersistenceUnitDescriptor {
        private final String name;

        public TestingPersistenceUnitDescriptorImpl(String name) {
            this.name = name;
        }

        public URL getPersistenceUnitRootUrl() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getProviderClassName() {
            return HibernatePersistenceProvider.class.getName();
        }

        public boolean isUseQuotedIdentifiers() {
            return false;
        }

        public boolean isExcludeUnlistedClasses() {
            return false;
        }

        public jakarta.persistence.spi.PersistenceUnitTransactionType getTransactionType() {
            return null;
        }

        public PersistenceUnitTransactionType getPersistenceUnitTransactionType() {
            return null;
        }

        public ValidationMode getValidationMode() {
            return null;
        }

        public SharedCacheMode getSharedCacheMode() {
            return null;
        }

        public List<String> getManagedClassNames() {
            return null;
        }

        public List<String> getMappingFileNames() {
            return null;
        }

        public List<URL> getJarFileUrls() {
            return null;
        }

        public Object getNonJtaDataSource() {
            return null;
        }

        public Object getJtaDataSource() {
            return null;
        }

        public Properties getProperties() {
            return null;
        }

        public ClassLoader getClassLoader() {
            return null;
        }

        public ClassLoader getTempClassLoader() {
            return null;
        }

        public void pushClassTransformer(EnhancementContext enhancementContext) {
        }

        public ClassTransformer getClassTransformer() {
            return null;
        }
    }
}

