/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.testing.orm.junit.DomainModelExtension;
import org.hibernate.testing.orm.junit.DomainModelScope;
import org.hibernate.testing.orm.junit.JUnitHelper;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class DomainModelParameterResolver
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return JUnitHelper.supportsParameterInjection(parameterContext, MetadataImplementor.class, DomainModelScope.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        DomainModelScope modelScope = DomainModelExtension.requireDomainModelScope(extensionContext.getRequiredTestInstance(), extensionContext);
        Class<DomainModelScope> parameterType = parameterContext.getParameter().getType();
        if (parameterType.isAssignableFrom(DomainModelScope.class)) {
            return modelScope;
        }
        if (parameterType.isAssignableFrom(MetadataImplementor.class)) {
            return modelScope.getDomainModel();
        }
        throw new IllegalStateException("Unsupported parameter type : " + parameterType.getName());
    }
}

