/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.testing.orm.junit.DialectContext;
import org.hibernate.testing.orm.junit.DialectFeatureCheck;
import org.hibernate.testing.orm.junit.RequiresDialect;
import org.hibernate.testing.orm.junit.RequiresDialectFeature;
import org.hibernate.testing.orm.junit.RequiresDialectFeatureGroup;
import org.hibernate.testing.orm.junit.RequiresDialects;
import org.hibernate.testing.orm.junit.SkipForDialect;
import org.hibernate.testing.orm.junit.SkipForDialectGroup;
import org.hibernate.testing.orm.junit.TestingUtil;
import org.hibernate.testing.orm.junit.VersionMatchMode;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class DialectFilterExtension
implements ExecutionCondition {
    private static final Logger log = Logger.getLogger(DialectFilterExtension.class);

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Dialect dialect = this.getDialect(context);
        if (dialect == null) {
            throw new RuntimeException("#getDialect returned null");
        }
        log.debugf("Checking Dialect [%s] - context = %s", (Object)dialect, (Object)context.getDisplayName());
        Collection<RequiresDialect> effectiveRequiresDialects = TestingUtil.collectAnnotations(context, RequiresDialect.class, RequiresDialects.class, (methodAnnotation, methodAnnotations, classAnnotation, classAnnotations) -> {
            LinkedHashMap<Class<? extends Dialect>, RequiresDialect> map = new LinkedHashMap<Class<? extends Dialect>, RequiresDialect>();
            if (classAnnotation != null) {
                map.put(classAnnotation.value(), (RequiresDialect)classAnnotation);
            }
            if (classAnnotations != null) {
                for (RequiresDialect annotation : classAnnotations) {
                    map.put(annotation.value(), annotation);
                }
            }
            if (methodAnnotation != null) {
                map.put(methodAnnotation.value(), (RequiresDialect)methodAnnotation);
            }
            if (methodAnnotations != null) {
                for (RequiresDialect annotation : methodAnnotations) {
                    map.put(annotation.value(), annotation);
                }
            }
            return map.values();
        });
        if (!effectiveRequiresDialects.isEmpty()) {
            StringBuilder requiredDialects = new StringBuilder();
            for (RequiresDialect requiresDialect : effectiveRequiresDialects) {
                boolean versionsMatch;
                requiredDialects.append(requiresDialect.value());
                requiredDialects.append(" ");
                int matchingMajorVersion = requiresDialect.majorVersion();
                if (matchingMajorVersion >= 0) {
                    int matchingMinorVersion = requiresDialect.minorVersion();
                    int matchingMicroVersion = requiresDialect.microVersion();
                    requiredDialects.append(", version = ");
                    requiredDialects.append(this.matchingVersionString(matchingMajorVersion, matchingMinorVersion, matchingMicroVersion));
                    requiredDialects.append(" ");
                    versionsMatch = DialectFilterExtension.versionsMatch(matchingMajorVersion, matchingMinorVersion, matchingMicroVersion, dialect, requiresDialect.versionMatchMode());
                } else {
                    versionsMatch = true;
                }
                if (!requiresDialect.value().isInstance(dialect) || !versionsMatch || !requiresDialect.matchSubTypes() && !requiresDialect.value().equals(dialect.getClass())) continue;
                return this.evaluateSkipConditions(context, dialect, "Matched @RequiresDialect");
            }
            return ConditionEvaluationResult.disabled((String)String.format(Locale.ROOT, "Failed @RequiresDialect(dialect=%s) check - found %s version %s]", requiredDialects, dialect.getClass().getName(), dialect.getVersion()));
        }
        return this.evaluateSkipConditions(context, dialect, "Passed all @SkipForDialects");
    }

    private String matchingVersionString(int matchingMajorVersion, int matchingMinorVersion, int matchingMicroVersion) {
        StringBuilder buffer = new StringBuilder(matchingMajorVersion);
        if (matchingMajorVersion > 0) {
            buffer.append(".").append(matchingMinorVersion);
            if (matchingMicroVersion > 0) {
                buffer.append(".").append(matchingMicroVersion);
            }
        }
        return buffer.toString();
    }

    public static boolean versionsMatch(int matchingMajorVersion, int matchingMinorVersion, int matchingMicroVersion, Dialect dialect, boolean matchNewerVersions) {
        return DialectFilterExtension.versionsMatch(matchingMajorVersion, matchingMinorVersion, matchingMicroVersion, dialect, matchNewerVersions ? VersionMatchMode.SAME_OR_NEWER : VersionMatchMode.SAME);
    }

    public static boolean versionsMatch(int matchingMajorVersion, int matchingMinorVersion, int matchingMicroVersion, Dialect dialect, VersionMatchMode matchMode) {
        if (matchingMajorVersion < 0) {
            return false;
        }
        int minorVersion = Math.max(matchingMinorVersion, 0);
        int microVersion = Math.max(matchingMicroVersion, 0);
        return switch (matchMode) {
            default -> throw new IncompatibleClassChangeError();
            case VersionMatchMode.SAME -> {
                if (matchingMicroVersion < 0) {
                    if (matchingMinorVersion < 0) {
                        yield dialect.getVersion().isSame(matchingMajorVersion);
                    }
                    yield dialect.getVersion().isSame(matchingMajorVersion, matchingMinorVersion);
                }
                yield dialect.getVersion().isSame(matchingMajorVersion, matchingMinorVersion, matchingMicroVersion);
            }
            case VersionMatchMode.SAME_OR_OLDER -> dialect.getVersion().isSameOrBefore(matchingMajorVersion, minorVersion, microVersion);
            case VersionMatchMode.SAME_OR_NEWER -> dialect.getVersion().isSameOrAfter(matchingMajorVersion, minorVersion, microVersion);
            case VersionMatchMode.NEWER -> dialect.getVersion().isAfter(matchingMajorVersion, minorVersion, microVersion);
            case VersionMatchMode.OLDER -> dialect.getVersion().isBefore(matchingMajorVersion, minorVersion, microVersion);
        };
    }

    private ConditionEvaluationResult evaluateSkipConditions(ExtensionContext context, Dialect dialect, String enabledResult) {
        Collection<SkipForDialect> effectiveSkips = TestingUtil.collectAnnotations(context, SkipForDialect.class, SkipForDialectGroup.class, (methodAnnotation, methodAnnotations, classAnnotation, classAnnotations) -> {
            LinkedHashMap<DialectVersionKey, SkipForDialect> map = new LinkedHashMap<DialectVersionKey, SkipForDialect>();
            if (classAnnotation != null) {
                map.put(DialectVersionKey.of(classAnnotation), (SkipForDialect)classAnnotation);
            }
            if (classAnnotations != null) {
                for (SkipForDialect annotation : classAnnotations) {
                    map.put(DialectVersionKey.of(annotation), annotation);
                }
            }
            if (methodAnnotation != null) {
                map.put(DialectVersionKey.of(methodAnnotation), (SkipForDialect)methodAnnotation);
            }
            if (methodAnnotations != null) {
                for (SkipForDialect annotation : methodAnnotations) {
                    map.put(DialectVersionKey.of(annotation), annotation);
                }
            }
            return map.values();
        });
        for (SkipForDialect effectiveSkipForDialect : effectiveSkips) {
            boolean versionsMatch;
            int matchingMajorVersion = effectiveSkipForDialect.majorVersion();
            if (!(matchingMajorVersion >= 0 ? (versionsMatch = DialectFilterExtension.versionsMatch(matchingMajorVersion, effectiveSkipForDialect.minorVersion(), effectiveSkipForDialect.microVersion(), dialect, effectiveSkipForDialect.versionMatchMode())) && (effectiveSkipForDialect.matchSubTypes() ? effectiveSkipForDialect.dialectClass().isInstance(dialect) : effectiveSkipForDialect.dialectClass().equals(dialect.getClass())) : (effectiveSkipForDialect.matchSubTypes() ? effectiveSkipForDialect.dialectClass().isInstance(dialect) : effectiveSkipForDialect.dialectClass().equals(dialect.getClass())))) continue;
            return ConditionEvaluationResult.disabled((String)"Matched @SkipForDialect");
        }
        Collection<RequiresDialectFeature> effectiveRequiresDialectFeatures = TestingUtil.collectAnnotations(context, RequiresDialectFeature.class, RequiresDialectFeatureGroup.class);
        for (RequiresDialectFeature effectiveRequiresDialectFeature : effectiveRequiresDialectFeatures) {
            try {
                Class<? extends DialectFeatureCheck> featureClass = effectiveRequiresDialectFeature.feature();
                DialectFeatureCheck featureCheck = featureClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                boolean testResult = featureCheck.apply(dialect);
                if (effectiveRequiresDialectFeature.reverse()) {
                    boolean bl = testResult = !testResult;
                }
                if (testResult) continue;
                return ConditionEvaluationResult.disabled((String)String.format(Locale.ROOT, "Failed @RequiresDialectFeature [%s]", featureClass));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Unable to instantiate DialectFeatureCheck class", e);
            }
        }
        return ConditionEvaluationResult.enabled((String)enabledResult);
    }

    private Dialect getDialect(ExtensionContext context) {
        return DialectContext.getDialect();
    }

    record DialectVersionKey(Class<? extends Dialect> dialect, DatabaseVersion version) {
        public static DialectVersionKey of(SkipForDialect annotation) {
            Class<? extends Dialect> dialectClass = annotation.dialectClass();
            int majorVersion = -9999;
            int minorVersion = -9999;
            int microVersion = -9999;
            if (annotation.majorVersion() != -1) {
                majorVersion = annotation.majorVersion();
                if (annotation.minorVersion() != -1) {
                    minorVersion += annotation.minorVersion();
                    if (annotation.microVersion() != -1) {
                        microVersion += annotation.microVersion();
                    }
                }
            }
            return new DialectVersionKey(dialectClass, (DatabaseVersion)new SimpleDatabaseVersion(majorVersion, minorVersion, microVersion));
        }
    }
}

