/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.testing.jdbc.GradleParallelTestingResolver;

public final class DialectContext {
    private static Class<? extends Dialect> dialectClass;
    private static Dialect dialect;

    static void initDialectClass() {
        Properties properties = Environment.getProperties();
        String dialectName = properties.getProperty("hibernate.dialect");
        if (dialectName == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            dialectClass = ReflectHelper.classForName((String)dialectName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName, (Throwable)cnfe);
        }
    }

    static void init() {
        Driver driver;
        Constructor<? extends Dialect> constructor;
        Properties properties = Environment.getProperties();
        String driverClassName = properties.getProperty("hibernate.connection.driver_class");
        String jdbcUrl = GradleParallelTestingResolver.resolveUrl(properties.getProperty("hibernate.connection.url"));
        Properties props = new Properties();
        GradleParallelTestingResolver.resolveFromSettings(properties);
        props.setProperty("user", properties.getProperty("hibernate.connection.username"));
        props.setProperty("password", properties.getProperty("hibernate.connection.password"));
        Class<? extends Dialect> dialectClass = DialectContext.getDialectClass();
        try {
            constructor = dialectClass.getConstructor(DialectResolutionInfo.class);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate given dialect class: " + String.valueOf(dialectClass), (Throwable)e);
        }
        try {
            driver = (Driver)Class.forName(driverClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("JDBC Driver class not found: " + driverClassName, (Throwable)cnfe);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate given JDBC driver class: " + driverClassName, (Throwable)e);
        }
        try (Connection connection = driver.connect(jdbcUrl, props);){
            dialect = constructor.newInstance(new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData()));
        }
        catch (SQLException sqle) {
            throw new JDBCConnectionException("Could not connect to database with JDBC URL '" + jdbcUrl + "' [" + sqle.getMessage() + "]", sqle);
        }
        catch (Exception e) {
            throw new HibernateException("Could not connect to database with dialect class: " + dialectClass.getName(), (Throwable)e);
        }
    }

    private DialectContext() {
    }

    public static synchronized Class<? extends Dialect> getDialectClass() {
        if (dialectClass == null) {
            DialectContext.initDialectClass();
        }
        return dialectClass;
    }

    public static synchronized Dialect getDialect() {
        if (dialect == null) {
            DialectContext.init();
        }
        return dialect;
    }
}

