/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.lang.reflect.Method;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.testing.orm.junit.AfterClassTemplate;
import org.hibernate.testing.orm.junit.BeforeClassTemplate;
import org.junit.jupiter.api.extension.AfterClassTemplateInvocationCallback;
import org.junit.jupiter.api.extension.BeforeClassTemplateInvocationCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;

@Incubating
public class ClassTemplateInvocationListenersExtension
implements BeforeClassTemplateInvocationCallback,
AfterClassTemplateInvocationCallback {
    public void beforeClassTemplateInvocation(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        List annotatedMethods = AnnotationSupport.findAnnotatedMethods((Class)testClass, BeforeClassTemplate.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        for (Method method : annotatedMethods) {
            context.getExecutableInvoker().invoke(method, context.getRequiredTestInstance());
        }
    }

    public void afterClassTemplateInvocation(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        List annotatedMethods = AnnotationSupport.findAnnotatedMethods((Class)testClass, AfterClassTemplate.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        for (Method method : annotatedMethods) {
            context.getExecutableInvoker().invoke(method, context.getRequiredTestInstance());
        }
    }
}

