/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.common;

import java.sql.Connection;
import java.util.Properties;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.util.PropertiesHelper;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.testing.orm.junit.BaseUnitTest;
import org.hibernate.testing.orm.junit.ServiceRegistry;
import org.hibernate.testing.orm.junit.ServiceRegistryScope;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

@BaseUnitTest
@ServiceRegistry
public abstract class BaseTransactionIsolationConfigTest {
    protected abstract ConnectionProvider getConnectionProviderUnderTest(ServiceRegistryScope var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingIsolationAsNumeric(ServiceRegistryScope registryScope) throws Exception {
        Properties properties = Environment.getProperties();
        properties.put("hibernate.connection.isolation", (Object)8);
        ConnectionProvider provider = this.getConnectionProviderUnderTest(registryScope);
        try {
            ((Configurable)provider).configure(PropertiesHelper.map((Properties)properties));
            if (provider instanceof Startable) {
                ((Startable)provider).start();
            }
            Connection connection = provider.getConnection();
            Assert.assertEquals((long)8L, (long)connection.getTransactionIsolation());
            provider.closeConnection(connection);
        }
        finally {
            ((Stoppable)provider).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingIsolationAsNumericString(ServiceRegistryScope registryScope) throws Exception {
        Properties properties = Environment.getProperties();
        properties.put("hibernate.connection.isolation", Integer.toString(8));
        ConnectionProvider provider = this.getConnectionProviderUnderTest(registryScope);
        try {
            ((Configurable)provider).configure(PropertiesHelper.map((Properties)properties));
            if (provider instanceof Startable) {
                ((Startable)provider).start();
            }
            Connection connection = provider.getConnection();
            Assert.assertEquals((long)8L, (long)connection.getTransactionIsolation());
            provider.closeConnection(connection);
        }
        finally {
            ((Stoppable)provider).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingIsolationAsName(ServiceRegistryScope registryScope) throws Exception {
        Properties properties = Environment.getProperties();
        properties.put("hibernate.connection.isolation", "TRANSACTION_SERIALIZABLE");
        ConnectionProvider provider = this.getConnectionProviderUnderTest(registryScope);
        try {
            ((Configurable)provider).configure(PropertiesHelper.map((Properties)properties));
            if (provider instanceof Startable) {
                ((Startable)provider).start();
            }
            Connection connection = provider.getConnection();
            Assert.assertEquals((long)8L, (long)connection.getTransactionIsolation());
            provider.closeConnection(connection);
        }
        finally {
            ((Stoppable)provider).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingIsolationAsNameAlt(ServiceRegistryScope registryScope) throws Exception {
        Properties properties = Environment.getProperties();
        properties.put("hibernate.connection.isolation", "SERIALIZABLE");
        ConnectionProvider provider = this.getConnectionProviderUnderTest(registryScope);
        try {
            ((Configurable)provider).configure(PropertiesHelper.map((Properties)properties));
            if (provider instanceof Startable) {
                ((Startable)provider).start();
            }
            Connection connection = provider.getConnection();
            Assert.assertEquals((long)8L, (long)connection.getTransactionIsolation());
            provider.closeConnection(connection);
        }
        finally {
            ((Stoppable)provider).stop();
        }
    }
}

