/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.memory;

import org.hibernate.testing.memory.GlobalMemoryUsageSnapshotter;
import org.hibernate.testing.memory.HotspotPerThreadAllocationSnapshotter;
import org.hibernate.testing.memory.HotspotTotalThreadBytesSnapshotter;
import org.hibernate.testing.memory.MemoryAllocationSnapshot;
import org.hibernate.testing.memory.MemoryAllocationSnapshotter;

public class MemoryUsageUtil {
    private static final MemoryAllocationSnapshotter SNAPSHOTTER;

    public static long estimateMemoryUsage(Runnable runnable) {
        MemoryAllocationSnapshot beforeSnapshot = SNAPSHOTTER.snapshot();
        runnable.run();
        return SNAPSHOTTER.snapshot().difference(beforeSnapshot);
    }

    static {
        MemoryAllocationSnapshotter snapshotter = HotspotTotalThreadBytesSnapshotter.getInstance();
        if (snapshotter == null) {
            snapshotter = HotspotPerThreadAllocationSnapshotter.getInstance();
        }
        if (snapshotter == null) {
            snapshotter = GlobalMemoryUsageSnapshotter.getInstance();
        }
        SNAPSHOTTER = snapshotter;
    }
}

