/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.testing.memory.MemoryAllocationSnapshot;
import org.hibernate.testing.memory.MemoryAllocationSnapshotter;

record HotspotPerThreadAllocationSnapshotter(ThreadMXBean threadMXBean) implements MemoryAllocationSnapshotter
{
    private static final @Nullable HotspotPerThreadAllocationSnapshotter INSTANCE;
    private static final Method GET_THREAD_ALLOCATED_BYTES;

    public static @Nullable HotspotPerThreadAllocationSnapshotter getInstance() {
        return INSTANCE;
    }

    @Override
    public MemoryAllocationSnapshot snapshot() {
        long[] threadIds = this.threadMXBean.getAllThreadIds();
        try {
            return new PerThreadMemoryAllocationSnapshot(threadIds, (long[])GET_THREAD_ALLOCATED_BYTES.invoke((Object)this.threadMXBean, new Object[]{threadIds}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Method method = null;
        try {
            Class<?> hotspotInterface = Class.forName("com.sun.management.ThreadMXBean");
            try {
                method = hotspotInterface.getMethod("getThreadAllocatedBytes", long[].class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!hotspotInterface.isInstance(threadMXBean)) {
                threadMXBean = (ThreadMXBean)ManagementFactory.getPlatformMXBean(hotspotInterface);
            }
        }
        catch (Throwable hotspotInterface) {
            // empty catch block
        }
        GET_THREAD_ALLOCATED_BYTES = method;
        HotspotPerThreadAllocationSnapshotter instance = null;
        if (method != null && threadMXBean != null) {
            try {
                instance = new HotspotPerThreadAllocationSnapshotter(threadMXBean);
                instance.snapshot();
            }
            catch (Exception e) {
                instance = null;
            }
        }
        INSTANCE = instance;
    }

    record PerThreadMemoryAllocationSnapshot(long[] threadIds, long[] threadAllocatedBytes) implements MemoryAllocationSnapshot
    {
        @Override
        public long difference(MemoryAllocationSnapshot before) {
            PerThreadMemoryAllocationSnapshot other = (PerThreadMemoryAllocationSnapshot)before;
            HashMap<Long, Integer> previousThreadIdToIndexMap = new HashMap<Long, Integer>();
            for (int i = 0; i < other.threadIds.length; ++i) {
                previousThreadIdToIndexMap.put(other.threadIds[i], i);
            }
            long allocatedBytes = 0L;
            for (int i = 0; i < this.threadIds.length; ++i) {
                allocatedBytes += this.threadAllocatedBytes[i];
                Integer previousThreadIndex = (Integer)previousThreadIdToIndexMap.get(this.threadIds[i]);
                if (previousThreadIndex == null) continue;
                allocatedBytes -= other.threadAllocatedBytes[previousThreadIndex];
            }
            return allocatedBytes;
        }
    }
}

