/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import org.jboss.logging.Logger;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ClassLoadingIsolater
implements MethodRule {
    private static final Logger log = Logger.getLogger(ClassLoadingIsolater.class);
    private final IsolatedClassLoaderProvider provider;

    public ClassLoadingIsolater(IsolatedClassLoaderProvider provider) {
        this.provider = provider;
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(this){
            final /* synthetic */ ClassLoadingIsolater this$0;
            {
                this.this$0 = this$0;
            }

            public void evaluate() throws Throwable {
                ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
                ClassLoader isolatedClassLoader = this.this$0.provider.buildIsolatedClassLoader();
                log.infof("Overriding TCCL [%s] -> [%s]", (Object)originalTCCL, (Object)isolatedClassLoader);
                Thread.currentThread().setContextClassLoader(isolatedClassLoader);
                try {
                    base.evaluate();
                }
                finally {
                    assert (Thread.currentThread().getContextClassLoader() == isolatedClassLoader);
                    log.infof("Reverting TCCL [%s] -> [%s]", (Object)isolatedClassLoader, (Object)originalTCCL);
                    Thread.currentThread().setContextClassLoader(originalTCCL);
                    this.this$0.provider.releaseIsolatedClassLoader(isolatedClassLoader);
                }
            }
        };
    }

    public static interface IsolatedClassLoaderProvider {
        public ClassLoader buildIsolatedClassLoader();

        public void releaseIsolatedClassLoader(ClassLoader var1);
    }
}

