/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.jdbc.leak.ConnectionLeakUtil;
import org.hibernate.testing.jta.TestingJtaPlatformImpl;
import org.hibernate.testing.junit4.CustomRunner;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;

@Deprecated
@RunWith(value=CustomRunner.class)
public abstract class BaseUnitTestCase {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static boolean enableConnectionLeakDetection = Boolean.TRUE.toString().equals(System.getenv("HIBERNATE_CONNECTION_LEAK_DETECTION"));
    private ConnectionLeakUtil connectionLeakUtil;
    protected final ExecutorService executorService = Executors.newSingleThreadExecutor();
    @Rule
    public TestRule globalTimeout = Timeout.millis((long)TimeUnit.MINUTES.toMillis(30L));

    public BaseUnitTestCase() {
        if (enableConnectionLeakDetection) {
            this.connectionLeakUtil = new ConnectionLeakUtil();
        }
    }

    @AfterClassOnce
    public void assertNoLeaks() {
        if (enableConnectionLeakDetection) {
            this.connectionLeakUtil.assertNoLeaks();
        }
    }

    @After
    public void releaseTransactions() {
        if (JtaStatusHelper.isActive((TransactionManager)TestingJtaPlatformImpl.INSTANCE.getTransactionManager())) {
            this.log.warn((Object)"Cleaning up unfinished transaction");
            try {
                TestingJtaPlatformImpl.INSTANCE.getTransactionManager().rollback();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    protected Future<?> executeAsync(Runnable callable) {
        return this.executorService.submit(callable);
    }

    protected void executeSync(Runnable callable) {
        try {
            this.executeAsync(callable).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

