/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.ServiceRegistry;

public class JdbcUtils {
    public static void withConnection(ServiceRegistry serviceRegistry, ConnectionAction action) {
        ConnectionProvider connections = (ConnectionProvider)serviceRegistry.requireService(ConnectionProvider.class);
        try {
            Connection connection = connections.getConnection();
            try {
                action.execute(connection);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                connections.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void withConnection(ConnectionProvider connections, ConnectionAction action) {
        try {
            Connection connection = connections.getConnection();
            try {
                action.execute(connection);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                connections.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface ConnectionAction {
        public void execute(Connection var1) throws SQLException;
    }
}

