/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProvider;
import org.hibernate.internal.util.PropertiesHelper;
import org.hibernate.testing.env.ConnectionProviderBuilder;

public class DataSourceStub
implements DataSource {
    private final String id;
    private final DriverManagerConnectionProvider connectionProvider;
    private PrintWriter printWriter;

    public DataSourceStub(String id) {
        this.id = id;
        this.connectionProvider = new DriverManagerConnectionProvider();
        this.connectionProvider.configure(PropertiesHelper.map((Properties)ConnectionProviderBuilder.getConnectionProviderProperties()));
        this.printWriter = null;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connectionProvider.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.printWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public int getLoginTimeout() {
        return -1;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getGlobal();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    public String toString() {
        return "DataSourceImpl(" + this.id + ")";
    }
}

