/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.env;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.DataSourceConnectionProvider;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.util.PropertiesHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.testing.DialectCheck;
import org.hibernate.testing.env.TestingDatabaseInfo;
import org.hibernate.testing.jdbc.ConnectionProviderDelegate;
import org.hibernate.testing.util.ServiceRegistryUtil;

public class ConnectionProviderBuilder
implements DialectCheck {
    public static final String DRIVER = "org.h2.Driver";
    public static final String DATA_SOURCE = "org.h2.jdbcx.JdbcDataSource";
    public static final String SHARED_DATABASE_NAME = "db1";
    public static final String URL_FORMAT = "jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;LOCK_TIMEOUT=10000;DB_CLOSE_ON_EXIT=FALSE";
    public static final String URL = String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;LOCK_TIMEOUT=10000;DB_CLOSE_ON_EXIT=FALSE", "db1");
    public static final String USER = "sa";
    public static final String PASS = "";

    public static Properties getConnectionProviderProperties(String dbName) {
        return ConnectionProviderBuilder.getConnectionProviderProperties(dbName, Collections.emptyMap());
    }

    public static Properties getConnectionProviderProperties(String dbName, Map<String, String> environmentOverrides) {
        Properties globalProperties = Environment.getProperties();
        globalProperties.putAll(environmentOverrides);
        assert (globalProperties.getProperty("hibernate.connection.url").startsWith("jdbc:h2:")) : "Connection provider properties are only usable when running against H2";
        Properties props = new Properties(null);
        props.put("hibernate.connection.driver_class", DRIVER);
        props.put("hibernate.connection.url", String.format(URL_FORMAT, dbName));
        props.put("hibernate.connection.username", USER);
        props.put("hibernate.connection.password", PASS);
        props.put("hibernate.connection.init_sql", PASS);
        props.put("hibernate.connection.autocommit", "false");
        if (SHARED_DATABASE_NAME.equals(dbName)) {
            ServiceRegistryUtil.applySettings(props);
        }
        return props;
    }

    public static Properties getJpaConnectionProviderProperties(String dbName) {
        Properties globalProperties = Environment.getProperties();
        assert (globalProperties.getProperty("hibernate.connection.url").startsWith("jdbc:h2:")) : "Connection provider properties are only usable when running against H2";
        Properties props = new Properties(null);
        props.put("javax.persistence.jdbc.driver", DRIVER);
        props.put("javax.persistence.jdbc.url", String.format(URL_FORMAT, dbName));
        props.put("javax.persistence.jdbc.user", USER);
        props.put("javax.persistence.jdbc.password", PASS);
        props.put("hibernate.connection.init_sql", PASS);
        props.put("hibernate.connection.autocommit", "false");
        if (SHARED_DATABASE_NAME.equals(dbName)) {
            ServiceRegistryUtil.applySettings(props);
        }
        return props;
    }

    public static Properties getConnectionProviderProperties() {
        return ConnectionProviderBuilder.getConnectionProviderProperties(SHARED_DATABASE_NAME);
    }

    public static Properties getJpaConnectionProviderProperties() {
        return ConnectionProviderBuilder.getJpaConnectionProviderProperties(SHARED_DATABASE_NAME);
    }

    public static ConnectionProvider buildConnectionProvider() {
        return ConnectionProviderBuilder.buildConnectionProvider(false);
    }

    public static ConnectionProvider buildConnectionProvider(String dbName) {
        return ConnectionProviderBuilder.buildConnectionProvider(ConnectionProviderBuilder.getConnectionProviderProperties(dbName), false);
    }

    public static ConnectionProvider buildConnectionProvider(String dbName, Map<String, String> environmentOverrides) {
        return ConnectionProviderBuilder.buildConnectionProvider(ConnectionProviderBuilder.getConnectionProviderProperties(dbName, environmentOverrides), false);
    }

    public static ConnectionProvider buildDataSourceConnectionProvider(String dbName) {
        Properties globalProperties = Environment.getProperties();
        assert (globalProperties.getProperty("hibernate.connection.url").startsWith("jdbc:h2:")) : "Connection provider properties are only usable when running against H2";
        try {
            Class dataSourceClass = ReflectHelper.classForName((String)DATA_SOURCE, ConnectionProviderBuilder.class);
            DataSource actualDataSource = (DataSource)dataSourceClass.newInstance();
            ReflectHelper.findSetterMethod((Class)dataSourceClass, (String)"URL", String.class).invoke((Object)actualDataSource, String.format(URL_FORMAT, dbName));
            ReflectHelper.findSetterMethod((Class)dataSourceClass, (String)"user", String.class).invoke((Object)actualDataSource, globalProperties.getProperty("hibernate.connection.username"));
            ReflectHelper.findSetterMethod((Class)dataSourceClass, (String)"password", String.class).invoke((Object)actualDataSource, globalProperties.getProperty("hibernate.connection.password"));
            final DataSourceInvocationHandler dataSourceInvocationHandler = new DataSourceInvocationHandler(actualDataSource);
            DataSourceConnectionProvider connectionProvider = new DataSourceConnectionProvider(){

                public void stop() {
                    dataSourceInvocationHandler.stop();
                }
            };
            connectionProvider.configure(Collections.singletonMap("hibernate.connection.datasource", Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)dataSourceInvocationHandler)));
            return connectionProvider;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ConnectionProvider buildConnectionProvider(boolean allowAggressiveRelease) {
        return ConnectionProviderBuilder.buildConnectionProvider(ConnectionProviderBuilder.getConnectionProviderProperties(SHARED_DATABASE_NAME), allowAggressiveRelease);
    }

    private static ConnectionProvider buildConnectionProvider(Properties props, final boolean allowAggressiveRelease) {
        ConnectionProviderDelegate connectionProvider = new ConnectionProviderDelegate(){

            @Override
            public boolean supportsAggressiveRelease() {
                return allowAggressiveRelease;
            }
        };
        if (props.containsKey("hibernate.connection.provider_class")) {
            connectionProvider.setConnectionProvider((ConnectionProvider)props.get("hibernate.connection.provider_class"));
        } else {
            connectionProvider.setConnectionProvider((ConnectionProvider)new DriverManagerConnectionProvider());
        }
        connectionProvider.configure(PropertiesHelper.map((Properties)props));
        return connectionProvider;
    }

    public static Dialect getCorrespondingDialect() {
        return TestingDatabaseInfo.DIALECT;
    }

    @Override
    public boolean isMatch(Dialect dialect) {
        return ConnectionProviderBuilder.getCorrespondingDialect().getClass().equals(dialect.getClass());
    }

    private static class DataSourceInvocationHandler
    implements InvocationHandler {
        private final DataSource target;
        private Connection actualConnection;
        private Connection connectionProxy;

        public DataSourceInvocationHandler(DataSource target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getConnection".equals(method.getName()) && this.actualConnection == null) {
                this.actualConnection = (Connection)method.invoke((Object)this.target, args);
                this.connectionProxy = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(this.actualConnection));
            }
            return this.connectionProxy;
        }

        public void stop() {
            try {
                this.actualConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        private static class ConnectionInvocationHandler
        implements InvocationHandler {
            private final Connection target;

            public ConnectionInvocationHandler(Connection target) {
                this.target = target;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("close".equals(method.getName())) {
                    return null;
                }
                return method.invoke((Object)this.target, args);
            }
        }
    }
}

