/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.service.Service;

public interface ServiceRegistryScope {
    public static void using(Supplier<StandardServiceRegistry> ssrProducer, Consumer<ServiceRegistryScope> action) {
        try (StandardServiceRegistry ssr = ssrProducer.get();){
            action.accept(() -> ssr);
        }
    }

    public StandardServiceRegistry getRegistry();

    default public <S extends Service> void withService(Class<S> role, Consumer<S> action) {
        if (!1.$assertionsDisabled && role == null) {
            throw new AssertionError();
        }
        Service service = this.getRegistry().getService(role);
        if (service == null) {
            throw new IllegalArgumentException("Could not locate requested service - " + role.getName());
        }
        action.accept(service);
    }

    default public <R, S extends Service> R fromService(Class<S> role, Function<S, R> action) {
        if (!1.$assertionsDisabled && role == null) {
            throw new AssertionError();
        }
        Service service = this.getRegistry().getService(role);
        if (service == null) {
            throw new IllegalArgumentException("Could not locate requested service - " + role.getName());
        }
        return action.apply(service);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

