/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.testing.jdbc.SQLStatementInspector;
import org.hibernate.testing.orm.junit.DomainModelExtension;
import org.hibernate.testing.orm.junit.DomainModelScope;
import org.hibernate.testing.orm.junit.JUnitHelper;
import org.hibernate.testing.orm.junit.SessionFactoryProducer;
import org.hibernate.testing.orm.junit.SessionFactoryScope;
import org.hibernate.testing.orm.junit.SessionFactoryScopeAware;
import org.hibernate.testing.orm.transaction.TransactionUtil;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;

public class SessionFactoryExtension
implements TestInstancePostProcessor,
BeforeEachCallback,
TestExecutionExceptionHandler {
    private static final Logger log = Logger.getLogger(SessionFactoryExtension.class);
    private static final String SESSION_FACTORY_KEY = SessionFactoryScope.class.getName();

    public static SessionFactoryScope findSessionFactoryScope(Object testInstance, ExtensionContext context) {
        ExtensionContext.Store store = SessionFactoryExtension.locateExtensionStore(testInstance, context);
        SessionFactoryScope existing = (SessionFactoryScope)store.get((Object)SESSION_FACTORY_KEY);
        if (existing != null) {
            return existing;
        }
        throw new RuntimeException("Could not locate SessionFactoryScope : " + context.getDisplayName());
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        log.tracef("#postProcessTestInstance(%s, %s)", testInstance, (Object)context.getDisplayName());
        Optional sfAnnRef = AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), org.hibernate.testing.orm.junit.SessionFactory.class);
        if (sfAnnRef.isPresent() || SessionFactoryProducer.class.isAssignableFrom(context.getRequiredTestClass())) {
            DomainModelScope domainModelScope = DomainModelExtension.findDomainModelScope(testInstance, context);
            SessionFactoryScopeImpl created = SessionFactoryExtension.createSessionFactoryScope(testInstance, sfAnnRef, domainModelScope, context);
            SessionFactoryExtension.locateExtensionStore(testInstance, context).put((Object)SESSION_FACTORY_KEY, (Object)created);
        }
    }

    public void beforeEach(ExtensionContext context) {
        Optional sfAnnRef = AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), org.hibernate.testing.orm.junit.SessionFactory.class);
        if (sfAnnRef.isEmpty()) {
            return;
        }
        DomainModelScope domainModelScope = DomainModelExtension.resolveForMethodLevelSessionFactoryScope(context);
        SessionFactoryScopeImpl created = SessionFactoryExtension.createSessionFactoryScope(context.getRequiredTestInstance(), sfAnnRef, domainModelScope, context);
        ExtensionContext.Store extensionStore = SessionFactoryExtension.locateExtensionStore(context.getRequiredTestInstance(), context);
        extensionStore.put((Object)SESSION_FACTORY_KEY, (Object)created);
    }

    private static ExtensionContext.Store locateExtensionStore(Object testInstance, ExtensionContext context) {
        return JUnitHelper.locateExtensionStore(SessionFactoryExtension.class, context, testInstance);
    }

    private static SessionFactoryScopeImpl createSessionFactoryScope(Object testInstance, Optional<org.hibernate.testing.orm.junit.SessionFactory> sfAnnRef, DomainModelScope domainModelScope, ExtensionContext context) {
        SessionFactoryProducer producer = null;
        if (testInstance instanceof SessionFactoryProducer) {
            producer = (SessionFactoryProducer)testInstance;
        } else {
            if (context.getElement().isEmpty()) {
                throw new RuntimeException("Unable to determine how to handle given ExtensionContext : " + context.getDisplayName());
            }
            if (sfAnnRef.isPresent()) {
                org.hibernate.testing.orm.junit.SessionFactory sessionFactoryConfig = sfAnnRef.get();
                producer = model -> {
                    try {
                        SessionFactoryBuilder sessionFactoryBuilder = model.getSessionFactoryBuilder();
                        if (StringHelper.isNotEmpty((String)sessionFactoryConfig.sessionFactoryName())) {
                            sessionFactoryBuilder.applyName(sessionFactoryConfig.sessionFactoryName());
                        }
                        if (sessionFactoryConfig.generateStatistics()) {
                            sessionFactoryBuilder.applyStatisticsSupport(true);
                        }
                        if (!sessionFactoryConfig.interceptorClass().equals(Interceptor.class)) {
                            sessionFactoryBuilder.applyInterceptor(sessionFactoryConfig.interceptorClass().newInstance());
                        }
                        Class<? extends StatementInspector> explicitInspectorClass = sessionFactoryConfig.statementInspectorClass();
                        if (sessionFactoryConfig.useCollectingStatementInspector()) {
                            sessionFactoryBuilder.applyStatementInspector((StatementInspector)new SQLStatementInspector());
                        } else if (!explicitInspectorClass.equals(StatementInspector.class)) {
                            sessionFactoryBuilder.applyStatementInspector(explicitInspectorClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        sessionFactoryBuilder.applyCollectionsInDefaultFetchGroup(sessionFactoryConfig.applyCollectionsInDefaultFetchGroup());
                        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)sessionFactoryBuilder.build();
                        if (sessionFactoryConfig.exportSchema()) {
                            SessionFactoryExtension.prepareSchemaExport(sessionFactory, model, sessionFactoryConfig.createSecondarySchemas());
                        }
                        return sessionFactory;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not build SessionFactory: " + e.getMessage(), e);
                    }
                };
            }
        }
        if (producer == null) {
            throw new IllegalStateException("Could not determine SessionFactory producer");
        }
        SessionFactoryScopeImpl sfScope = new SessionFactoryScopeImpl(domainModelScope, producer);
        if (testInstance instanceof SessionFactoryScopeAware) {
            ((SessionFactoryScopeAware)testInstance).injectSessionFactoryScope(sfScope);
        }
        return sfScope;
    }

    private static void prepareSchemaExport(SessionFactoryImplementor sessionFactory, MetadataImplementor model, boolean createSecondarySchemas) {
        Map baseProperties = sessionFactory.getProperties();
        Set groupings = SchemaManagementToolCoordinator.ActionGrouping.interpret((Metadata)model, (Map)baseProperties);
        if (!groupings.isEmpty()) {
            return;
        }
        HashMap<String, Object> settings = new HashMap<String, Object>(baseProperties);
        settings.put("jakarta.persistence.schema-generation.database.action", Action.CREATE_DROP);
        if (createSecondarySchemas) {
            if (!model.getDatabase().getDialect().canCreateSchema()) {
                throw new UnsupportedOperationException(String.valueOf(model.getDatabase().getDialect()) + " does not support schema creation");
            }
            settings.put("jakarta.persistence.create-database-schemas", true);
        }
        final StandardServiceRegistry serviceRegistry = model.getMetadataBuildingOptions().getServiceRegistry();
        SchemaManagementToolCoordinator.process((Metadata)model, (ServiceRegistry)serviceRegistry, settings, action -> sessionFactory.addObserver(new SessionFactoryObserver(){

            public void sessionFactoryClosing(SessionFactory factory) {
                action.perform((ServiceRegistry)serviceRegistry);
            }
        }));
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        log.tracef("#handleTestExecutionException(%s, %s)", (Object)context.getDisplayName(), (Object)throwable);
        try {
            Object testInstance = context.getRequiredTestInstance();
            ExtensionContext.Store store = SessionFactoryExtension.locateExtensionStore(testInstance, context);
            SessionFactoryScopeImpl scope = (SessionFactoryScopeImpl)store.get((Object)SESSION_FACTORY_KEY);
            scope.releaseSessionFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw throwable;
    }

    private static class SessionFactoryScopeImpl
    implements SessionFactoryScope,
    AutoCloseable {
        private final DomainModelScope modelScope;
        private final SessionFactoryProducer producer;
        private SessionFactoryImplementor sessionFactory;
        private boolean active = true;

        private SessionFactoryScopeImpl(DomainModelScope modelScope, SessionFactoryProducer producer) {
            this.modelScope = modelScope;
            this.producer = producer;
        }

        @Override
        public SessionFactoryImplementor getSessionFactory() {
            if (this.sessionFactory == null) {
                this.sessionFactory = this.createSessionFactory();
            }
            return this.sessionFactory;
        }

        @Override
        public MetadataImplementor getMetadataImplementor() {
            return this.modelScope.getDomainModel();
        }

        @Override
        public StatementInspector getStatementInspector() {
            return this.getSessionFactory().getSessionFactoryOptions().getStatementInspector();
        }

        @Override
        public <T extends StatementInspector> T getStatementInspector(Class<T> type) {
            return (T)this.getStatementInspector();
        }

        @Override
        public SQLStatementInspector getCollectingStatementInspector() {
            return this.getStatementInspector(SQLStatementInspector.class);
        }

        @Override
        public void close() {
            if (!this.active) {
                return;
            }
            log.debug((Object)"Closing SessionFactoryScope");
            this.active = false;
            this.releaseSessionFactory();
        }

        public void releaseSessionFactory() {
            if (this.sessionFactory != null) {
                log.debug((Object)"Releasing SessionFactory");
                try {
                    this.sessionFactory.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Error closing SF", (Throwable)e);
                }
                finally {
                    this.sessionFactory = null;
                }
            }
        }

        private SessionFactoryImplementor createSessionFactory() {
            if (!this.active) {
                throw new IllegalStateException("SessionFactoryScope is no longer active");
            }
            log.debug((Object)"Creating SessionFactory");
            return this.producer.produceSessionFactory(this.modelScope.getDomainModel());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inSession(Consumer<SessionImplementor> action) {
            log.trace((Object)"#inSession(Consumer)");
            try (SessionImplementor session = this.getSessionFactory().openSession();){
                log.trace((Object)"Session opened, calling action");
                action.accept(session);
            }
            finally {
                log.trace((Object)"Session close - auto-close block");
            }
        }

        @Override
        public <T> T fromSession(Function<SessionImplementor, T> action) {
            log.trace((Object)"#fromSession(Function)");
            try {
                T t;
                block9: {
                    SessionImplementor session = this.getSessionFactory().openSession();
                    try {
                        log.trace((Object)"Session opened, calling action");
                        t = action.apply(session);
                        if (session == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    session.close();
                }
                return t;
            }
            finally {
                log.trace((Object)"Session close - auto-close block");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inTransaction(Consumer<SessionImplementor> action) {
            log.trace((Object)"#inTransaction(Consumer)");
            try (SessionImplementor session = this.getSessionFactory().openSession();){
                log.trace((Object)"Session opened, calling action");
                this.inTransaction(session, action);
            }
            finally {
                log.trace((Object)"Session close - auto-close block");
            }
        }

        @Override
        public <T> T fromTransaction(Function<SessionImplementor, T> action) {
            log.trace((Object)"#fromTransaction(Function)");
            try {
                T t;
                block9: {
                    SessionImplementor session = this.getSessionFactory().openSession();
                    try {
                        log.trace((Object)"Session opened, calling action");
                        t = this.fromTransaction(session, action);
                        if (session == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    session.close();
                }
                return t;
            }
            finally {
                log.trace((Object)"Session close - auto-close block");
            }
        }

        @Override
        public void inTransaction(SessionImplementor session, Consumer<SessionImplementor> action) {
            log.trace((Object)"inTransaction(Session,Consumer)");
            TransactionUtil.inTransaction(session, action);
        }

        @Override
        public <T> T fromTransaction(SessionImplementor session, Function<SessionImplementor, T> action) {
            log.trace((Object)"fromTransaction(Session,Function)");
            return TransactionUtil.fromTransaction(session, action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inStatelessSession(Consumer<StatelessSession> action) {
            log.trace((Object)"#inStatelessSession(Consumer)");
            try (StatelessSession statelessSession = this.getSessionFactory().openStatelessSession();){
                log.trace((Object)"StatelessSession opened, calling action");
                action.accept(statelessSession);
            }
            finally {
                log.trace((Object)"StatelessSession close - auto-close block");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inStatelessTransaction(Consumer<StatelessSession> action) {
            log.trace((Object)"#inStatelessTransaction(Consumer)");
            try (StatelessSession statelessSession = this.getSessionFactory().openStatelessSession();){
                log.trace((Object)"StatelessSession opened, calling action");
                this.inStatelessTransaction(statelessSession, action);
            }
            finally {
                log.trace((Object)"StatelessSession close - auto-close block");
            }
        }

        @Override
        public void inStatelessTransaction(StatelessSession session, Consumer<StatelessSession> action) {
            log.trace((Object)"inStatelessTransaction(StatelessSession,Consumer)");
            TransactionUtil.inTransaction(session, action);
        }

        @Override
        public void dropData() {
            if (this.sessionFactory != null) {
                this.sessionFactory.getSchemaManager().truncateMappedObjects();
            }
        }
    }
}

