/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import org.hibernate.testing.orm.junit.ExpectedException;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;

public class ExpectedExceptionExtension
implements TestExecutionExceptionHandler {
    private static final Logger log = Logger.getLogger(ExpectedExceptionExtension.class);

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        ExpectedException annotation = context.getRequiredTestMethod().getAnnotation(ExpectedException.class);
        if (annotation != null && annotation.value().isInstance(throwable)) {
            log.debugf("Test [%s] threw exception [%s] which matched @ExpectedException : swallowing exception", (Object)context.getDisplayName(), (Object)throwable);
            return;
        }
        throw throwable;
    }
}

