/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.env;

import java.util.function.BiConsumer;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;

public final class TestingDatabaseInfo {
    public static volatile String DRIVER = "org.h2.Driver";
    public static volatile String URL = "jdbc:h2:mem:db1;DB_CLOSE_DELAY=-1;LOCK_TIMEOUT=10000;DB_CLOSE_ON_EXIT=FALSE";
    public static volatile String USER = "sa";
    public static volatile String PASS = "";
    public static final Dialect DIALECT = new H2Dialect();

    public static void forEachSetting(BiConsumer<String, String> consumer) {
        consumer.accept("jakarta.persistence.jdbc.driver", DRIVER);
        consumer.accept("jakarta.persistence.jdbc.url", URL);
        consumer.accept("jakarta.persistence.jdbc.user", USER);
        consumer.accept("jakarta.persistence.jdbc.password", PASS);
        consumer.accept("hibernate.dialect", DIALECT.getClass().getName());
    }

    public static Configuration buildBaseConfiguration() {
        Configuration configuration = new Configuration();
        TestingDatabaseInfo.forEachSetting((arg_0, arg_1) -> ((Configuration)configuration).setProperty(arg_0, arg_1));
        return configuration;
    }

    private TestingDatabaseInfo() {
    }
}

