/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyJpaImpl;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.build.AllowPrintStacktrace;
import org.hibernate.internal.build.AllowSysOut;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jdbc.Work;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.hibernate.testing.OnExpectedFailure;
import org.hibernate.testing.OnFailure;
import org.hibernate.testing.cache.CachingRegionFactory;
import org.hibernate.testing.junit4.BaseCoreFunctionalTestCase;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.hibernate.testing.junit4.Helper;
import org.hibernate.testing.transaction.TransactionUtil2;
import org.hibernate.testing.util.ServiceRegistryUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class BaseNonConfigCoreFunctionalTestCase
extends BaseUnitTestCase {
    public static final String VALIDATE_DATA_CLEANUP = "hibernate.test.validateDataCleanup";
    private StandardServiceRegistry serviceRegistry;
    private MetadataImplementor metadata;
    private SessionFactoryImplementor sessionFactory;
    private Session session;
    protected static final String[] NO_MAPPINGS = new String[0];
    protected static final Class<?>[] NO_CLASSES = new Class[0];

    protected Dialect getDialect() {
        return this.serviceRegistry != null ? ((JdbcEnvironment)this.serviceRegistry.getService(JdbcEnvironment.class)).getDialect() : BaseCoreFunctionalTestCase.getDialect();
    }

    protected StandardServiceRegistry serviceRegistry() {
        return this.serviceRegistry;
    }

    protected MetadataImplementor metadata() {
        return this.metadata;
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    protected Session openSession() throws HibernateException {
        this.session = this.sessionFactory().openSession();
        return this.session;
    }

    protected Session openSession(Interceptor interceptor) throws HibernateException {
        this.session = this.sessionFactory().withOptions().interceptor(interceptor).openSession();
        return this.session;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void rebuildSessionFactory() {
        this.releaseResources();
        this.buildResources();
    }

    protected void cleanupCache() {
        if (this.sessionFactory != null) {
            this.sessionFactory.getCache().evictAllRegions();
        }
    }

    @BeforeClassOnce
    protected void startUp() {
        this.buildResources();
    }

    protected void buildResources() {
        StandardServiceRegistryBuilder serviceRegistryBuilder = this.constructStandardServiceRegistryBuilder();
        this.serviceRegistry = serviceRegistryBuilder.build();
        this.afterStandardServiceRegistryBuilt(this.serviceRegistry);
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)this.serviceRegistry);
        this.applyMetadataSources(metadataSources);
        this.afterMetadataSourcesApplied(metadataSources);
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        this.initialize(metadataBuilder);
        this.configureMetadataBuilder(metadataBuilder);
        this.metadata = (MetadataImplementor)metadataBuilder.build();
        if (this.overrideCacheStrategy() && this.getCacheConcurrencyStrategy() != null) {
            this.applyCacheSettings((Metadata)this.metadata);
        }
        this.afterMetadataBuilt((Metadata)this.metadata);
        SessionFactoryBuilder sfb = this.metadata.getSessionFactoryBuilder();
        this.initialize(sfb, (Metadata)this.metadata);
        this.configureSessionFactoryBuilder(sfb);
        this.sessionFactory = (SessionFactoryImplementor)sfb.build();
        this.afterSessionFactoryBuilt(this.sessionFactory);
    }

    protected final StandardServiceRegistryBuilder constructStandardServiceRegistryBuilder() {
        BootstrapServiceRegistryBuilder builder = new BootstrapServiceRegistryBuilder();
        builder.applyClassLoader(this.getClass().getClassLoader());
        builder.enableAutoClose();
        this.configureBootstrapServiceRegistryBuilder(builder);
        BootstrapServiceRegistry bootstrapServiceRegistry = builder.build();
        this.afterBootstrapServiceRegistryBuilt(bootstrapServiceRegistry);
        Map<String, Object> settings = BaseNonConfigCoreFunctionalTestCase.defaultSettings();
        this.addSettings(settings);
        StandardServiceRegistryBuilder registryBuilder = ServiceRegistryUtil.serviceRegistryBuilder(bootstrapServiceRegistry);
        this.initialize(registryBuilder);
        registryBuilder.applySettings(settings);
        this.configureStandardServiceRegistryBuilder(registryBuilder);
        return registryBuilder;
    }

    private static Map<String, Object> defaultSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("hibernate.query.mutation_strategy.persistent.drop_tables", "true");
        settings.put("hibernate.query.mutation_strategy.global_temporary.drop_tables", "true");
        settings.put("hibernate.query.mutation_strategy.local_temporary.drop_tables", "true");
        return settings;
    }

    protected void addSettings(Map<String, Object> settings) {
    }

    protected void configureBootstrapServiceRegistryBuilder(BootstrapServiceRegistryBuilder registryBuilder) {
    }

    protected void afterBootstrapServiceRegistryBuilt(BootstrapServiceRegistry bootstrapServiceRegistry) {
    }

    private void initialize(StandardServiceRegistryBuilder builder) {
        Dialect dialect = BaseCoreFunctionalTestCase.getDialect();
        builder.applySetting("hibernate.cache.region.factory_class", (Object)CachingRegionFactory.class.getName());
        if (this.createSchema()) {
            builder.applySetting("hibernate.hbm2ddl.auto", (Object)"create-drop");
            String secondSchemaName = this.createSecondSchema();
            if (StringHelper.isNotEmpty((String)secondSchemaName)) {
                if (!(dialect instanceof H2Dialect)) {
                    throw new UnsupportedOperationException("Only H2 dialect supports creation of second schema.");
                }
                Helper.createH2Schema(secondSchemaName, builder.getSettings());
            }
        }
        builder.applySetting("hibernate.dialect", (Object)dialect.getClass().getName());
    }

    protected boolean createSchema() {
        return true;
    }

    protected String createSecondSchema() {
        return null;
    }

    protected void configureStandardServiceRegistryBuilder(StandardServiceRegistryBuilder serviceRegistryBuilder) {
    }

    protected void afterStandardServiceRegistryBuilt(StandardServiceRegistry standardServiceRegistry) {
    }

    protected void applyMetadataSources(MetadataSources sources) {
        for (String mapping : this.getMappings()) {
            sources.addResource(this.getBaseForMappings() + mapping);
        }
        for (Class<?> annotatedClass : this.getAnnotatedClasses()) {
            sources.addAnnotatedClass((Class)annotatedClass);
        }
        for (String annotatedPackage : this.getAnnotatedPackages()) {
            sources.addPackage(annotatedPackage);
        }
        for (String ormXmlFile : this.getXmlFiles()) {
            sources.addInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(ormXmlFile));
        }
    }

    protected String[] getMappings() {
        return NO_MAPPINGS;
    }

    protected String getBaseForMappings() {
        return "org/hibernate/test/";
    }

    protected Class<?>[] getAnnotatedClasses() {
        return NO_CLASSES;
    }

    protected String[] getAnnotatedPackages() {
        return NO_MAPPINGS;
    }

    protected String[] getXmlFiles() {
        return NO_MAPPINGS;
    }

    protected void afterMetadataSourcesApplied(MetadataSources metadataSources) {
    }

    protected void initialize(MetadataBuilder metadataBuilder) {
        metadataBuilder.applyImplicitNamingStrategy((ImplicitNamingStrategy)ImplicitNamingStrategyLegacyJpaImpl.INSTANCE);
    }

    protected void configureMetadataBuilder(MetadataBuilder metadataBuilder) {
    }

    protected boolean overrideCacheStrategy() {
        return true;
    }

    protected String getCacheConcurrencyStrategy() {
        return null;
    }

    protected final void applyCacheSettings(Metadata metadata) {
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            if (entityBinding.isInherited() || BaseNonConfigCoreFunctionalTestCase.hasLob(entityBinding)) continue;
            RootClass rootClass = (RootClass)entityBinding;
            rootClass.setCacheConcurrencyStrategy(this.getCacheConcurrencyStrategy());
            entityBinding.setCached(true);
        }
        for (Collection collectionBinding : metadata.getCollectionBindings()) {
            if (BaseNonConfigCoreFunctionalTestCase.isLob(collectionBinding)) continue;
            collectionBinding.setCacheConcurrencyStrategy(this.getCacheConcurrencyStrategy());
        }
    }

    private static boolean isLob(Collection collectionBinding) {
        return collectionBinding.getElement().isSimpleValue() && BaseNonConfigCoreFunctionalTestCase.isLob((SimpleValue)collectionBinding.getElement());
    }

    private static boolean hasLob(PersistentClass entityBinding) {
        for (Property prop : entityBinding.getPropertyClosure()) {
            if (!prop.getValue().isSimpleValue() || !BaseNonConfigCoreFunctionalTestCase.isLob((SimpleValue)prop.getValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean isLob(SimpleValue value) {
        String typeName = value.getTypeName();
        if (typeName != null) {
            String significantTypeNamePart;
            switch (significantTypeNamePart = typeName.substring(typeName.lastIndexOf(46) + 1).toLowerCase(Locale.ROOT)) {
                case "blob": 
                case "blobtype": 
                case "clob": 
                case "clobtype": 
                case "nclob": 
                case "nclobtype": {
                    return true;
                }
            }
        }
        return false;
    }

    protected void afterMetadataBuilt(Metadata metadata) {
    }

    private void initialize(SessionFactoryBuilder sessionFactoryBuilder, Metadata metadata) {
    }

    protected void configureSessionFactoryBuilder(SessionFactoryBuilder sfb) {
    }

    protected void afterSessionFactoryBuilt(SessionFactoryImplementor sessionFactory) {
    }

    @AfterClassOnce
    protected void shutDown() {
        this.releaseResources();
    }

    @AllowSysOut
    @AllowPrintStacktrace
    protected void releaseResources() {
        if (this.sessionFactory != null) {
            try {
                this.sessionFactory.close();
            }
            catch (Exception e) {
                System.err.println("Unable to release SessionFactory : " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.sessionFactory = null;
        if (this.serviceRegistry != null) {
            try {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
            }
            catch (Exception e) {
                System.err.println("Unable to release StandardServiceRegistry : " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.serviceRegistry = null;
    }

    @OnFailure
    @OnExpectedFailure
    public void onFailure() {
        if (this.rebuildSessionFactoryOnError()) {
            this.rebuildSessionFactory();
        }
    }

    protected boolean rebuildSessionFactoryOnError() {
        return true;
    }

    @Before
    public final void beforeTest() throws Exception {
        this.prepareTest();
    }

    protected void prepareTest() throws Exception {
    }

    @After
    public final void afterTest() throws Exception {
        try {
            if (this.getDialect() instanceof H2Dialect) {
                ReflectHelper.getMethod(Class.forName("org.h2.util.DateTimeUtils"), (String)"resetCalendar", (Class[])new Class[0]).invoke(null, new Object[0]);
            }
            this.completeStrayTransaction();
            if (this.isCleanupTestDataRequired()) {
                this.cleanupTestData();
            }
            this.cleanupTest();
        }
        finally {
            this.cleanupSession();
        }
        this.assertAllDataRemoved();
    }

    private void completeStrayTransaction() {
        if (this.session == null) {
            return;
        }
        SessionImplementor sessionImplementor = (SessionImplementor)this.session;
        if (sessionImplementor.isClosed()) {
            return;
        }
        if (!this.session.isConnected()) {
            return;
        }
        if (BaseNonConfigCoreFunctionalTestCase.canRollback(sessionImplementor)) {
            try {
                this.session.getTransaction().rollback();
            }
            catch (RuntimeException e) {
                this.log.debug((Object)"Ignoring exception during clean up", (Throwable)e);
            }
        }
    }

    private static boolean canRollback(SessionImplementor sessionImplementor) {
        return sessionImplementor.getTransactionCoordinator().getTransactionDriverControl().getStatus().canRollback();
    }

    protected boolean isCleanupTestDataRequired() {
        return false;
    }

    protected void cleanupTestData() throws Exception {
        this.sessionFactory.getSchemaManager().truncateMappedObjects();
    }

    private void cleanupSession() {
        if (this.session != null && !((SessionImplementor)this.session).isClosed()) {
            this.session.close();
        }
        this.session = null;
    }

    protected void cleanupTest() throws Exception {
    }

    @AllowSysOut
    protected void assertAllDataRemoved() {
        if (!this.createSchema()) {
            return;
        }
        if (!Boolean.getBoolean(VALIDATE_DATA_CLEANUP)) {
            return;
        }
        try (SessionImplementor tmpSession = this.sessionFactory.openSession();){
            List list = tmpSession.createSelectionQuery("select o from java.lang.Object o", Object.class).getResultList();
            HashMap<String, Integer> items = new HashMap<String, Integer>();
            if (!list.isEmpty()) {
                for (Object element : list) {
                    Integer l = (Integer)items.get(tmpSession.getEntityName(element));
                    if (l == null) {
                        l = 0;
                    }
                    l = l + 1;
                    items.put(tmpSession.getEntityName(element), l);
                    System.out.println("Data left: " + String.valueOf(element));
                }
                Assert.fail((String)("Data is left in the database: " + String.valueOf(items)));
            }
        }
    }

    public void inSession(Consumer<SessionImplementor> action) {
        this.log.trace((Object)"#inSession(action)");
        TransactionUtil2.inSession(this.sessionFactory(), action);
    }

    public void inStatelessSession(Consumer<StatelessSession> action) {
        this.log.trace((Object)"#inSession(action)");
        TransactionUtil2.inStatelessSession(this.sessionFactory(), action);
    }

    public <R> R fromSession(Function<SessionImplementor, R> action) {
        this.log.trace((Object)"#inSession(action)");
        return TransactionUtil2.fromSession(this.sessionFactory(), action);
    }

    public void inTransaction(Consumer<SessionImplementor> action) {
        this.log.trace((Object)"#inTransaction(action)");
        TransactionUtil2.inTransaction(this.sessionFactory(), action);
    }

    public void inStatelessTransaction(Consumer<StatelessSession> action) {
        this.log.trace((Object)"#inTransaction(action)");
        TransactionUtil2.inStatelessTransaction(this.sessionFactory(), action);
    }

    public <R> R fromTransaction(Function<SessionImplementor, R> action) {
        this.log.trace((Object)"#inTransaction(action)");
        return TransactionUtil2.fromTransaction(this.sessionFactory(), action);
    }

    public static class RollbackWork
    implements Work {
        public void execute(Connection connection) throws SQLException {
            connection.rollback();
        }
    }
}

