/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import org.hibernate.testing.memory.MemoryAllocationSnapshot;
import org.hibernate.testing.memory.MemoryAllocationSnapshotter;

final class GlobalMemoryUsageSnapshotter
implements MemoryAllocationSnapshotter {
    private static final GlobalMemoryUsageSnapshotter INSTANCE = new GlobalMemoryUsageSnapshotter(ManagementFactory.getMemoryPoolMXBeans());
    private final List<MemoryPoolMXBean> heapPoolBeans;
    private final Runnable gcAndWait;

    private GlobalMemoryUsageSnapshotter(List<MemoryPoolMXBean> heapPoolBeans) {
        this.heapPoolBeans = heapPoolBeans;
        this.gcAndWait = () -> {
            for (int i = 0; i < 3; ++i) {
                System.gc();
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    public static GlobalMemoryUsageSnapshotter getInstance() {
        return INSTANCE;
    }

    @Override
    public MemoryAllocationSnapshot snapshot() {
        long peakUsage = this.heapPoolBeans.stream().mapToLong(p -> p.getPeakUsage().getUsed()).sum();
        this.gcAndWait.run();
        long retainedUsage = this.heapPoolBeans.stream().mapToLong(p -> p.getUsage().getUsed()).sum();
        this.heapPoolBeans.forEach(MemoryPoolMXBean::resetPeakUsage);
        return new GlobalMemoryAllocationSnapshot(peakUsage, retainedUsage);
    }

    record GlobalMemoryAllocationSnapshot(long peakUsage, long retainedUsage) implements MemoryAllocationSnapshot
    {
        @Override
        public long difference(MemoryAllocationSnapshot before) {
            return this.peakUsage - this.retainedUsage;
        }
    }
}

