/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.testing.memory.MemoryAllocationSnapshot;
import org.hibernate.testing.memory.MemoryAllocationSnapshotter;

record HotspotTotalThreadBytesSnapshotter(ThreadMXBean threadMXBean) implements MemoryAllocationSnapshotter
{
    private static final @Nullable HotspotTotalThreadBytesSnapshotter INSTANCE;
    private static final Method GET_TOTAL_THREAD_ALLOCATED_BYTES;

    public static @Nullable HotspotTotalThreadBytesSnapshotter getInstance() {
        return INSTANCE;
    }

    @Override
    public MemoryAllocationSnapshot snapshot() {
        try {
            return new GlobalMemoryAllocationSnapshot((Long)GET_TOTAL_THREAD_ALLOCATED_BYTES.invoke((Object)this.threadMXBean, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Method method = null;
        try {
            Class<?> hotspotInterface = Class.forName("com.sun.management.ThreadMXBean");
            try {
                method = hotspotInterface.getMethod("getTotalThreadAllocatedBytes", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!hotspotInterface.isInstance(threadMXBean)) {
                threadMXBean = (ThreadMXBean)ManagementFactory.getPlatformMXBean(hotspotInterface);
            }
        }
        catch (Throwable hotspotInterface) {
            // empty catch block
        }
        GET_TOTAL_THREAD_ALLOCATED_BYTES = method;
        HotspotTotalThreadBytesSnapshotter instance = null;
        if (method != null && threadMXBean != null) {
            try {
                instance = new HotspotTotalThreadBytesSnapshotter(threadMXBean);
                instance.snapshot();
            }
            catch (Exception e) {
                instance = null;
            }
        }
        INSTANCE = instance;
    }

    record GlobalMemoryAllocationSnapshot(long allocatedBytes) implements MemoryAllocationSnapshot
    {
        GlobalMemoryAllocationSnapshot {
            if (allocatedBytes == -1L) {
                throw new IllegalArgumentException("getTotalThreadAllocatedBytes is disabled");
            }
        }

        @Override
        public long difference(MemoryAllocationSnapshot before) {
            GlobalMemoryAllocationSnapshot other = (GlobalMemoryAllocationSnapshot)before;
            return Math.max(this.allocatedBytes - other.allocatedBytes, 0L);
        }
    }
}

