/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.junit.Assert;

public class SQLStatementInspector
implements StatementInspector {
    private final List<String> sqlQueries = new LinkedList<String>();

    public String inspect(String sql) {
        this.sqlQueries.add(sql);
        return sql;
    }

    public List<String> getSqlQueries() {
        return this.sqlQueries;
    }

    public void clear() {
        this.sqlQueries.clear();
    }

    public int getNumberOfJoins(int position) {
        String sql = this.sqlQueries.get(position);
        String fromPart = sql.toLowerCase(Locale.ROOT).split(" from ")[1].split(" where ")[0];
        return fromPart.split("(\\sjoin\\s|,\\s)", -1).length - 1;
    }

    public void assertExecuted(String expected) {
        Assert.assertTrue((boolean)this.sqlQueries.contains(expected));
    }

    public void assertNumberOfJoins(int queryNumber, int expectedNumberOfJoins) {
        this.assertNumberOfOccurrenceInQuery(queryNumber, "join", expectedNumberOfJoins);
    }

    public void assertExecutedCount(int expected) {
        Assert.assertEquals((String)"Number of executed statements ", (long)expected, (long)this.sqlQueries.size());
    }

    public void assertNumberOfJoins(int queryNumber, SqlAstJoinType joinType, int expectedNumberOfOccurrences) {
        String query = this.sqlQueries.get(queryNumber);
        String[] parts = query.split(" join ");
        int actual = this.getCount(parts, joinType);
        Assert.assertThat((String)("number of " + joinType.getText() + "join"), (Object)actual, (Matcher)CoreMatchers.is((Object)expectedNumberOfOccurrences));
    }

    private int getCount(String[] parts, SqlAstJoinType joinType) {
        int end = parts.length - 1;
        int count = 0;
        for (int i = 0; i < end; ++i) {
            if (parts[i].endsWith(" left")) {
                count += joinType == SqlAstJoinType.LEFT ? 1 : 0;
                continue;
            }
            if (parts[i].endsWith(" right")) {
                count += joinType == SqlAstJoinType.RIGHT ? 1 : 0;
                continue;
            }
            if (parts[i].endsWith(" full")) {
                count += joinType == SqlAstJoinType.FULL ? 1 : 0;
                continue;
            }
            if (parts[i].endsWith(" cross")) {
                count += joinType == SqlAstJoinType.CROSS ? 1 : 0;
                continue;
            }
            count += joinType == SqlAstJoinType.INNER ? 1 : 0;
        }
        return count;
    }

    public void assertNumberOfOccurrenceInQuery(int queryNumber, String toCheck, int expectedNumberOfOccurrences) {
        this.assertNumberOfOccurrenceInQueryNoSpace(queryNumber, " " + toCheck + " ", expectedNumberOfOccurrences);
    }

    public void assertNumberOfOccurrenceInQueryNoSpace(int queryNumber, String toCheck, int expectedNumberOfOccurrences) {
        String query = this.sqlQueries.get(queryNumber);
        int actual = query.split(toCheck, -1).length - 1;
        Assert.assertThat((String)("number of " + toCheck), (Object)actual, (Matcher)CoreMatchers.is((Object)expectedNumberOfOccurrences));
    }

    public void assertIsSelect(int queryNumber) {
        String query = this.sqlQueries.get(queryNumber);
        Assert.assertTrue((boolean)query.toLowerCase(Locale.ROOT).startsWith("select"));
    }

    public void assertIsInsert(int queryNumber) {
        String query = this.sqlQueries.get(queryNumber);
        Assert.assertTrue((boolean)query.toLowerCase(Locale.ROOT).startsWith("insert"));
    }

    public void assertIsUpdate(int queryNumber) {
        String query = this.sqlQueries.get(queryNumber);
        Assert.assertTrue((boolean)query.toLowerCase(Locale.ROOT).startsWith("update"));
    }

    public void assertNoUpdate() {
        ((ListAssert)Assertions.assertThat(this.sqlQueries).isNotEmpty()).allSatisfy(sql -> Assertions.assertThat((String)sql.toLowerCase(Locale.ROOT)).doesNotStartWith((CharSequence)"update"));
    }

    public void assertUpdate() {
        ((ListAssert)Assertions.assertThat(this.sqlQueries).isNotEmpty()).anySatisfy(sql -> Assertions.assertThat((String)sql.toLowerCase(Locale.ROOT)).startsWith((CharSequence)"update"));
    }

    public void assertInsert() {
        ((ListAssert)Assertions.assertThat(this.sqlQueries).isNotEmpty()).anySatisfy(sql -> Assertions.assertThat((String)sql.toLowerCase(Locale.ROOT)).startsWith((CharSequence)"insert"));
    }

    public static SQLStatementInspector extractFromSession(SessionImplementor session) {
        return (SQLStatementInspector)session.getJdbcSessionContext().getStatementInspector();
    }

    public void assertHasQueryMatching(String queryPattern) {
        ((ListAssert)Assertions.assertThat(this.sqlQueries).isNotEmpty()).anySatisfy(sql -> Assertions.assertThat((String)sql.toLowerCase(Locale.ROOT)).matches((CharSequence)queryPattern));
    }
}

