/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class SharedDriverManagerConnectionProviderImpl
extends DriverManagerConnectionProviderImpl {
    private static final SharedDriverManagerConnectionProviderImpl INSTANCE = new SharedDriverManagerConnectionProviderImpl();
    private static final Set<String> PGJDBC_STANDARD_TYPE_NAMES = SharedDriverManagerConnectionProviderImpl.buildTypeNames(Set.of("int2", "int4", "oid", "int8", "money", "numeric", "float4", "float8", "char", "bpchar", "varchar", "text", "name", "bytea", "bool", "bit", "date", "time", "timetz", "timestamp", "timestamptz", "refcursor", "json", "jsonb", "box", "point", "uuid", "xml"));
    private Config config;
    private Boolean supportsIsValid;

    private static Set<String> buildTypeNames(Set<String> baseTypeNames) {
        HashSet<String> typeNames = new HashSet<String>(baseTypeNames.size() * 3);
        for (String baseTypeName : baseTypeNames) {
            typeNames.add(baseTypeName);
            typeNames.add("_" + baseTypeName);
            typeNames.add(baseTypeName + "[]");
        }
        return typeNames;
    }

    public static SharedDriverManagerConnectionProviderImpl getInstance() {
        return INSTANCE;
    }

    public void configure(Map<String, Object> configurationValues) {
        Config c = new Config(configurationValues);
        if (!c.isCompatible(this.config)) {
            if (this.config != null) {
                super.stop();
            }
            super.configure(configurationValues);
            this.config = c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(Connection connection) throws SQLException {
        if (this.supportsIsValid == Boolean.FALSE) {
            return true;
        }
        Boolean supportsIsValid = Boolean.FALSE;
        try {
            boolean valid = connection.isValid(5);
            supportsIsValid = Boolean.TRUE;
            boolean bl = valid;
            return bl;
        }
        catch (AbstractMethodError e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.supportsIsValid = supportsIsValid;
        }
    }

    public void stop() {
        this.validateConnectionsReturned();
    }

    public void clearTypeCache() {
        if ("oracle.jdbc.OracleDriver".equals(this.config.driverClassName)) {
            this.validateConnections(c -> {
                try {
                    Class<?> oracleConnection = Class.forName("oracle.jdbc.OracleConnection");
                    Object connection = c.unwrap(oracleConnection);
                    oracleConnection.getMethod("removeAllDescriptor", new Class[0]).invoke(connection, new Object[0]);
                    return true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        } else if ("org.postgresql.Driver".equals(this.config.driverClassName)) {
            this.validateConnections(c -> {
                try {
                    Class<?> pgConnection = Class.forName("org.postgresql.jdbc.PgConnection");
                    Object connection = c.unwrap(pgConnection);
                    Object typeInfo = pgConnection.getMethod("getTypeInfo", new Class[0]).invoke(connection, new Object[0]);
                    Class<?> typeInfoCacheClass = Class.forName("org.postgresql.jdbc.TypeInfoCache");
                    Field oidToPgNameField = typeInfoCacheClass.getDeclaredField("oidToPgName");
                    Field pgNameToOidField = typeInfoCacheClass.getDeclaredField("pgNameToOid");
                    Field pgNameToSQLTypeField = typeInfoCacheClass.getDeclaredField("pgNameToSQLType");
                    Field oidToSQLTypeField = typeInfoCacheClass.getDeclaredField("oidToSQLType");
                    oidToPgNameField.setAccessible(true);
                    pgNameToOidField.setAccessible(true);
                    pgNameToSQLTypeField.setAccessible(true);
                    oidToSQLTypeField.setAccessible(true);
                    Map oidToPgName = (Map)oidToPgNameField.get(typeInfo);
                    Map pgNameToOid = (Map)pgNameToOidField.get(typeInfo);
                    Map pgNameToSQLType = (Map)pgNameToSQLTypeField.get(typeInfo);
                    Map oidToSQLType = (Map)oidToSQLTypeField.get(typeInfo);
                    Iterator iter = pgNameToOid.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        String typeName = (String)entry.getKey();
                        if (PGJDBC_STANDARD_TYPE_NAMES.contains(typeName)) continue;
                        Integer oid = (Integer)entry.getValue();
                        oidToPgName.remove(oid);
                        oidToSQLType.remove(oid);
                        pgNameToSQLType.remove(typeName);
                        iter.remove();
                    }
                    return true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        } else if ("com.edb.Driver".equals(this.config.driverClassName)) {
            this.validateConnections(c -> {
                try {
                    Class<?> pgConnection = Class.forName("com.edb.jdbc.PgConnection");
                    Object connection = c.unwrap(pgConnection);
                    Object typeInfo = pgConnection.getMethod("getTypeInfo", new Class[0]).invoke(connection, new Object[0]);
                    Class<?> typeInfoCacheClass = Class.forName("com.edb.jdbc.TypeInfoCache");
                    Field oidToPgNameField = typeInfoCacheClass.getDeclaredField("oidToPgName");
                    Field pgNameToOidField = typeInfoCacheClass.getDeclaredField("pgNameToOid");
                    Field pgNameToSQLTypeField = typeInfoCacheClass.getDeclaredField("pgNameToSQLType");
                    Field oidToSQLTypeField = typeInfoCacheClass.getDeclaredField("oidToSQLType");
                    oidToPgNameField.setAccessible(true);
                    pgNameToOidField.setAccessible(true);
                    pgNameToSQLTypeField.setAccessible(true);
                    oidToSQLTypeField.setAccessible(true);
                    Map oidToPgName = (Map)oidToPgNameField.get(typeInfo);
                    Map pgNameToOid = (Map)pgNameToOidField.get(typeInfo);
                    Map pgNameToSQLType = (Map)pgNameToSQLTypeField.get(typeInfo);
                    Map oidToSQLType = (Map)oidToSQLTypeField.get(typeInfo);
                    Iterator iter = pgNameToOid.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        String typeName = (String)entry.getKey();
                        if (PGJDBC_STANDARD_TYPE_NAMES.contains(typeName)) continue;
                        Integer oid = (Integer)entry.getValue();
                        oidToPgName.remove(oid);
                        oidToSQLType.remove(oid);
                        pgNameToSQLType.remove(typeName);
                        iter.remove();
                    }
                    return true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public void onDefaultTimeZoneChange() {
        if ("org.h2.Driver".equals(this.config.driverClassName) || "org.hsqldb.jdbc.JDBCDriver".equals(this.config.driverClassName)) {
            super.stop();
        }
    }

    public void reset() {
        super.stop();
    }

    public int getOpenConnections() {
        return super.getOpenConnections();
    }

    private static class Config {
        private final boolean autoCommit;
        private final int minSize;
        private final int maxSize;
        private final int initialSize;
        private final String driverClassName;
        private final String url;
        private final Properties connectionProps;
        private final Integer isolation;

        public Config(Map<String, Object> configurationValues) {
            this.autoCommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", configurationValues);
            this.minSize = ConfigurationHelper.getInt((String)"hibernate.connection.min_pool_size", configurationValues, (int)0);
            this.maxSize = ConfigurationHelper.getInt((String)"hibernate.connection.pool_size", configurationValues, (int)20);
            this.initialSize = ConfigurationHelper.getInt((String)"hibernate.connection.initial_pool_size", configurationValues, (int)this.minSize);
            this.driverClassName = (String)configurationValues.get("hibernate.connection.driver_class");
            this.url = (String)configurationValues.get("hibernate.connection.url");
            this.connectionProps = ConnectionProviderInitiator.getConnectionProperties(configurationValues);
            this.isolation = ConnectionProviderInitiator.extractIsolation(configurationValues);
        }

        boolean isCompatible(Config config) {
            return config != null && this.autoCommit == config.autoCommit && this.minSize == config.minSize && this.maxSize == config.maxSize && this.initialSize == config.initialSize && this.driverClassName.equals(config.driverClassName) && this.url.equals(config.url) && this.connectionProps.equals(config.connectionProps) && Objects.equals(this.isolation, config.isolation);
        }
    }
}

