/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jta;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.internal.arjuna.objectstore.VolatileStore;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionSynchronizationRegistry;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JtaSynchronizationStrategy;
import org.hibernate.engine.transaction.jta.platform.internal.SynchronizationRegistryAccess;
import org.hibernate.engine.transaction.jta.platform.internal.SynchronizationRegistryBasedSynchronizationStrategy;

public class TestingJtaPlatformImpl
extends AbstractJtaPlatform {
    public static final String NAME = TestingJtaPlatformImpl.class.getName();
    public static final TestingJtaPlatformImpl INSTANCE = new TestingJtaPlatformImpl();
    private final jakarta.transaction.TransactionManager transactionManager;
    private final jakarta.transaction.UserTransaction userTransaction;
    private final TransactionSynchronizationRegistry synchronizationRegistry;
    private final JtaSynchronizationStrategy synchronizationStrategy;

    public TestingJtaPlatformImpl() {
        ((ObjectStoreEnvironmentBean)BeanPopulator.getDefaultInstance(ObjectStoreEnvironmentBean.class)).setObjectStoreType(VolatileStore.class.getName());
        ((ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"communicationStore")).setObjectStoreType(VolatileStore.class.getName());
        ((ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"stateStore")).setObjectStoreType(VolatileStore.class.getName());
        this.transactionManager = TransactionManager.transactionManager();
        this.userTransaction = UserTransaction.userTransaction();
        this.synchronizationRegistry = new TransactionSynchronizationRegistryImple();
        this.synchronizationStrategy = new SynchronizationRegistryBasedSynchronizationStrategy(new SynchronizationRegistryAccess(){

            public TransactionSynchronizationRegistry getSynchronizationRegistry() {
                return TestingJtaPlatformImpl.this.synchronizationRegistry;
            }
        });
    }

    public static jakarta.transaction.TransactionManager transactionManager() {
        return INSTANCE.retrieveTransactionManager();
    }

    public static jakarta.transaction.UserTransaction userTransaction() {
        return INSTANCE.retrieveUserTransaction();
    }

    public static TransactionSynchronizationRegistry synchronizationRegistry() {
        return TestingJtaPlatformImpl.INSTANCE.synchronizationRegistry;
    }

    public static void tryCommit() throws Exception {
        if (TestingJtaPlatformImpl.transactionManager().getStatus() == 1) {
            TestingJtaPlatformImpl.transactionManager().rollback();
        } else {
            TestingJtaPlatformImpl.transactionManager().commit();
        }
    }

    public static void inNoopJtaTransaction(jakarta.transaction.TransactionManager tm, Runnable action) throws Exception {
        tm.begin();
        action.run();
        tm.rollback();
    }

    public static void inJtaTransaction(jakarta.transaction.TransactionManager tm, Runnable action) throws Exception {
        TestingJtaPlatformImpl.inJtaTransaction(tm, -1, action);
    }

    public static void inJtaTransaction(jakarta.transaction.TransactionManager tm, int timeout, Runnable action) throws Exception {
        if (timeout > 0) {
            try {
                tm.setTransactionTimeout(timeout);
            }
            catch (SystemException e) {
                throw new RuntimeException("Unable to set requested JTA timeout", e);
            }
        }
        try {
            tm.begin();
        }
        catch (NotSupportedException | SystemException e) {
            throw new RuntimeException("TransactionManager#begin exception", e);
        }
        try {
            action.run();
            tm.commit();
        }
        catch (Exception e) {
            try {
                tm.rollback();
            }
            catch (SystemException ex) {
                throw new RuntimeException(ex);
            }
            throw e;
        }
    }

    protected jakarta.transaction.TransactionManager locateTransactionManager() {
        return this.transactionManager;
    }

    protected boolean canCacheTransactionManager() {
        return true;
    }

    protected jakarta.transaction.UserTransaction locateUserTransaction() {
        return this.userTransaction;
    }

    protected boolean canCacheUserTransaction() {
        return true;
    }

    protected JtaSynchronizationStrategy getSynchronizationStrategy() {
        return this.synchronizationStrategy;
    }
}

