/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import jakarta.persistence.AttributeConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.DuplicateMappingException;
import org.hibernate.MappingException;
import org.hibernate.annotations.CollectionTypeRegistration;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.NamedProcedureCallDefinitionImpl;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.TypeDefinitionRegistry;
import org.hibernate.boot.model.convert.spi.ConverterAutoApplyHandler;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterRegistry;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.models.spi.GlobalRegistrations;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.NamedResultSetMappingDescriptor;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.EffectiveMappingDefaults;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.NaturalIdUniqueKeyBinder;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.community.dialect.DerbyDialect;
import org.hibernate.community.dialect.FirebirdDialect;
import org.hibernate.community.dialect.InformixDialect;
import org.hibernate.community.dialect.TiDBDialect;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HANADialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.PostgreSQLDriverKind;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SpannerDialect;
import org.hibernate.dialect.SybaseASEDialect;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.dialect.SybaseDriverKind;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.internal.SqlTypedMappingImpl;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.testing.boot.BootstrapContextImpl;
import org.hibernate.testing.orm.junit.DialectFeatureCheck;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;

public abstract class DialectFeatureChecks {
    private static final HashMap<Dialect, SqmFunctionRegistry> FUNCTION_REGISTRIES = new HashMap();

    public static boolean definesFunction(Dialect dialect, String functionName) {
        return DialectFeatureChecks.getSqmFunctionRegistry(dialect).findFunctionDescriptor(functionName) != null;
    }

    public static boolean definesSetReturningFunction(Dialect dialect, String functionName) {
        return DialectFeatureChecks.getSqmFunctionRegistry(dialect).findSetReturningFunctionDescriptor(functionName) != null;
    }

    private static SqmFunctionRegistry getSqmFunctionRegistry(Dialect dialect) {
        SqmFunctionRegistry sqmFunctionRegistry = FUNCTION_REGISTRIES.get(dialect);
        if (sqmFunctionRegistry == null) {
            TypeConfiguration typeConfiguration = new TypeConfiguration();
            SqmFunctionRegistry functionRegistry = new SqmFunctionRegistry();
            typeConfiguration.scope((MetadataBuildingContext)new FakeMetadataBuildingContext(typeConfiguration, functionRegistry));
            FakeTypeContributions typeContributions = new FakeTypeContributions(typeConfiguration);
            FakeFunctionContributions functionContributions = new FakeFunctionContributions(dialect, typeConfiguration, functionRegistry);
            dialect.contribute((TypeContributions)typeContributions, typeConfiguration.getServiceRegistry());
            dialect.initializeFunctionRegistry((FunctionContributions)functionContributions);
            sqmFunctionRegistry = functionContributions.functionRegistry;
            FUNCTION_REGISTRIES.put(dialect, sqmFunctionRegistry);
        }
        return sqmFunctionRegistry;
    }

    public static class FakeMetadataBuildingContext
    implements MetadataBuildingContext,
    InFlightMetadataCollector {
        private final TypeConfiguration typeConfiguration;
        private final SqmFunctionRegistry functionRegistry;
        private final MetadataBuilderImpl.MetadataBuildingOptionsImpl options;
        private final BootstrapContextImpl bootstrapContext;
        private final Database database;

        public FakeMetadataBuildingContext(TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry) {
            this.typeConfiguration = typeConfiguration;
            this.functionRegistry = functionRegistry;
            this.bootstrapContext = new BootstrapContextImpl();
            this.options = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(this.bootstrapContext.getServiceRegistry());
            this.options.setBootstrapContext((BootstrapContext)this.bootstrapContext);
            this.database = new Database((MetadataBuildingOptions)this.options, null);
        }

        public BootstrapContext getBootstrapContext() {
            return this.bootstrapContext;
        }

        public MetadataBuildingOptions getBuildingOptions() {
            return this.options;
        }

        public Database getDatabase() {
            return this.database;
        }

        public MetadataBuildingOptions getMetadataBuildingOptions() {
            return this.options;
        }

        public TypeConfiguration getTypeConfiguration() {
            return this.typeConfiguration;
        }

        public SqmFunctionRegistry getFunctionRegistry() {
            return this.functionRegistry;
        }

        public EffectiveMappingDefaults getEffectiveDefaults() {
            return null;
        }

        public InFlightMetadataCollector getMetadataCollector() {
            return this;
        }

        public ObjectNameNormalizer getObjectNameNormalizer() {
            return null;
        }

        public TypeDefinitionRegistry getTypeDefinitionRegistry() {
            return null;
        }

        public String getCurrentContributorName() {
            return "";
        }

        public GlobalRegistrations getGlobalRegistrations() {
            return null;
        }

        public PersistenceUnitMetadata getPersistenceUnitMetadata() {
            return null;
        }

        public void addEntityBinding(PersistentClass persistentClass) throws DuplicateMappingException {
        }

        public Map<String, PersistentClass> getEntityBindingMap() {
            return Map.of();
        }

        public void registerComponent(Component component) {
        }

        public void registerGenericComponent(Component component) {
        }

        public void registerEmbeddableSubclass(ClassDetails superclass, ClassDetails subclass) {
        }

        public List<ClassDetails> getEmbeddableSubclasses(ClassDetails superclass) {
            return List.of();
        }

        public void addImport(String importName, String className) throws DuplicateMappingException {
        }

        public void addCollectionBinding(org.hibernate.mapping.Collection collection) throws DuplicateMappingException {
        }

        public Table addTable(String schema, String catalog, String name, String subselect, boolean isAbstract, MetadataBuildingContext buildingContext) {
            return null;
        }

        public Table addDenormalizedTable(String schema, String catalog, String name, boolean isAbstract, String subselect, Table includedTable, MetadataBuildingContext buildingContext) throws DuplicateMappingException {
            return null;
        }

        public void addNamedQuery(NamedHqlQueryDefinition<?> query) throws DuplicateMappingException {
        }

        public void addNamedNativeQuery(NamedNativeQueryDefinition<?> query) throws DuplicateMappingException {
        }

        public void addResultSetMapping(NamedResultSetMappingDescriptor resultSetMappingDefinition) throws DuplicateMappingException {
        }

        public void addNamedProcedureCallDefinition(NamedProcedureCallDefinition definition) throws DuplicateMappingException {
        }

        public void addNamedEntityGraph(NamedEntityGraphDefinition namedEntityGraphDefinition) {
        }

        public void addTypeDefinition(TypeDefinition typeDefinition) {
        }

        public void addFilterDefinition(FilterDefinition definition) {
        }

        public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        }

        public void addFetchProfile(FetchProfile profile) {
        }

        public void addIdentifierGenerator(IdentifierGeneratorDefinition generatorDefinition) {
        }

        public ConverterRegistry getConverterRegistry() {
            return null;
        }

        public void addAttributeConverter(ConverterDescriptor descriptor) {
        }

        public void addAttributeConverter(Class<? extends AttributeConverter<?, ?>> converterClass) {
        }

        public void addRegisteredConversion(RegisteredConversion conversion) {
        }

        public ConverterAutoApplyHandler getAttributeConverterAutoApplyHandler() {
            return null;
        }

        public void addSecondPass(SecondPass secondPass) {
        }

        public void addSecondPass(SecondPass sp, boolean onTopOfTheQueue) {
        }

        public void addTableNameBinding(Identifier logicalName, Table table) {
        }

        public void addTableNameBinding(String schema, String catalog, String logicalName, String realTableName, Table denormalizedSuperTable) {
        }

        public String getLogicalTableName(Table ownerTable) {
            return "";
        }

        public String getPhysicalTableName(Identifier logicalName) {
            return "";
        }

        public String getPhysicalTableName(String logicalName) {
            return "";
        }

        public void addColumnNameBinding(Table table, Identifier logicalColumnName, Column column) {
        }

        public void addColumnNameBinding(Table table, String logicalColumnName, Column column) {
        }

        public String getPhysicalColumnName(Table table, Identifier logicalName) throws MappingException {
            return "";
        }

        public String getPhysicalColumnName(Table table, String logicalName) throws MappingException {
            return "";
        }

        public String getLogicalColumnName(Table table, Identifier physicalName) {
            return "";
        }

        public String getLogicalColumnName(Table table, String physicalName) {
            return "";
        }

        public void addDefaultIdentifierGenerator(IdentifierGeneratorDefinition generatorDefinition) {
        }

        public void addDefaultQuery(NamedHqlQueryDefinition<?> queryDefinition) {
        }

        public void addDefaultNamedNativeQuery(NamedNativeQueryDefinition<?> query) {
        }

        public void addDefaultResultSetMapping(NamedResultSetMappingDescriptor definition) {
        }

        public void addDefaultNamedProcedureCall(NamedProcedureCallDefinitionImpl procedureCallDefinition) {
        }

        public AnnotatedClassType addClassType(ClassDetails classDetails) {
            return null;
        }

        public AnnotatedClassType getClassType(ClassDetails classDetails) {
            return null;
        }

        public void addMappedSuperclass(Class<?> type, MappedSuperclass mappedSuperclass) {
        }

        public MappedSuperclass getMappedSuperclass(Class<?> type) {
            return null;
        }

        public PropertyData getPropertyAnnotatedWithMapsId(ClassDetails persistentClassDetails, String propertyName) {
            return null;
        }

        public void addPropertyAnnotatedWithMapsId(ClassDetails entityClassDetails, PropertyData propertyAnnotatedElement) {
        }

        public void addToOneAndIdProperty(ClassDetails entityClassDetails, PropertyData propertyAnnotatedElement) {
        }

        public PropertyData getPropertyAnnotatedWithIdAndToOne(ClassDetails persistentClassDetails, String propertyName) {
            return null;
        }

        public boolean isInSecondPass() {
            return false;
        }

        public NaturalIdUniqueKeyBinder locateNaturalIdUniqueKeyBinder(String entityName) {
            return null;
        }

        public void registerNaturalIdUniqueKeyBinder(String entityName, NaturalIdUniqueKeyBinder ukBinder) {
        }

        public void registerValueMappingResolver(Function<MetadataBuildingContext, Boolean> resolver) {
        }

        public void addJavaTypeRegistration(Class<?> javaType, JavaType<?> jtd) {
        }

        public void addJdbcTypeRegistration(int typeCode, JdbcType jdbcType) {
        }

        public void registerEmbeddableInstantiator(Class<?> embeddableType, Class<? extends EmbeddableInstantiator> instantiator) {
        }

        public Class<? extends EmbeddableInstantiator> findRegisteredEmbeddableInstantiator(Class<?> embeddableType) {
            return null;
        }

        public void registerCompositeUserType(Class<?> embeddableType, Class<? extends CompositeUserType<?>> userType) {
        }

        public Class<? extends CompositeUserType<?>> findRegisteredCompositeUserType(Class<?> embeddableType) {
            return null;
        }

        public void registerUserType(Class<?> embeddableType, Class<? extends UserType<?>> userType) {
        }

        public Class<? extends UserType<?>> findRegisteredUserType(Class<?> basicType) {
            return null;
        }

        public void addCollectionTypeRegistration(CollectionTypeRegistration registrationAnnotation) {
        }

        public void addCollectionTypeRegistration(CollectionClassification classification, InFlightMetadataCollector.CollectionTypeRegistrationDescriptor descriptor) {
        }

        public InFlightMetadataCollector.CollectionTypeRegistrationDescriptor findCollectionTypeRegistration(CollectionClassification classification) {
            return null;
        }

        public void addDelayedPropertyReferenceHandler(InFlightMetadataCollector.DelayedPropertyReferenceHandler handler) {
        }

        public void addPropertyReference(String entityName, String propertyName) {
        }

        public void addUniquePropertyReference(String entityName, String propertyName) {
        }

        public void addPropertyReferencedAssociation(String entityName, String propertyName, String syntheticPropertyName) {
        }

        public String getPropertyReferencedAssociation(String entityName, String mappedBy) {
            return "";
        }

        public void addMappedBy(String name, String mappedBy, String propertyName) {
        }

        public String getFromMappedBy(String ownerEntityName, String propertyName) {
            return "";
        }

        public InFlightMetadataCollector.EntityTableXref getEntityTableXref(String entityName) {
            return null;
        }

        public InFlightMetadataCollector.EntityTableXref addEntityTableXref(String entityName, Identifier primaryTableLogicalName, Table primaryTable, InFlightMetadataCollector.EntityTableXref superEntityTableXref) {
            return null;
        }

        public Map<String, Join> getJoins(String entityName) {
            return Map.of();
        }

        public SessionFactoryBuilder getSessionFactoryBuilder() {
            return null;
        }

        public SessionFactoryImplementor buildSessionFactory() {
            return null;
        }

        public UUID getUUID() {
            return null;
        }

        public Collection<PersistentClass> getEntityBindings() {
            return List.of();
        }

        public PersistentClass getEntityBinding(String entityName) {
            return null;
        }

        public Collection<org.hibernate.mapping.Collection> getCollectionBindings() {
            return List.of();
        }

        public org.hibernate.mapping.Collection getCollectionBinding(String role) {
            return null;
        }

        public Map<String, String> getImports() {
            return Map.of();
        }

        public NamedHqlQueryDefinition<?> getNamedHqlQueryMapping(String name) {
            return null;
        }

        public void visitNamedHqlQueryDefinitions(Consumer<NamedHqlQueryDefinition<?>> definitionConsumer) {
        }

        public NamedNativeQueryDefinition<?> getNamedNativeQueryMapping(String name) {
            return null;
        }

        public void visitNamedNativeQueryDefinitions(Consumer<NamedNativeQueryDefinition<?>> definitionConsumer) {
        }

        public NamedProcedureCallDefinition getNamedProcedureCallMapping(String name) {
            return null;
        }

        public void visitNamedProcedureCallDefinition(Consumer<NamedProcedureCallDefinition> definitionConsumer) {
        }

        public NamedResultSetMappingDescriptor getResultSetMapping(String name) {
            return null;
        }

        public void visitNamedResultSetMappingDefinition(Consumer<NamedResultSetMappingDescriptor> definitionConsumer) {
        }

        public TypeDefinition getTypeDefinition(String typeName) {
            return null;
        }

        public Map<String, FilterDefinition> getFilterDefinitions() {
            return Map.of();
        }

        public FilterDefinition getFilterDefinition(String name) {
            return null;
        }

        public FetchProfile getFetchProfile(String name) {
            return null;
        }

        public Collection<FetchProfile> getFetchProfiles() {
            return List.of();
        }

        public NamedEntityGraphDefinition getNamedEntityGraph(String name) {
            return null;
        }

        public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphs() {
            return Map.of();
        }

        public IdentifierGeneratorDefinition getIdentifierGenerator(String name) {
            return null;
        }

        public Collection<Table> collectTableMappings() {
            return List.of();
        }

        public Map<String, SqmFunctionDescriptor> getSqlFunctionMap() {
            return Map.of();
        }

        public Set<String> getContributors() {
            return Set.of();
        }

        public NamedObjectRepository buildNamedQueryRepository() {
            return null;
        }

        public void orderColumns(boolean forceOrdering) {
        }

        public void validate() throws MappingException {
        }

        public Set<MappedSuperclass> getMappedSuperclassMappingsCopy() {
            return Set.of();
        }

        public void initSessionFactory(SessionFactoryImplementor sessionFactoryImplementor) {
        }

        public void visitRegisteredComponents(Consumer<Component> consumer) {
        }

        public Component getGenericComponent(Class<?> componentClass) {
            return null;
        }

        public DiscriminatorType<?> resolveEmbeddableDiscriminatorType(Class<?> embeddableClass, Supplier<DiscriminatorType<?>> supplier) {
            return null;
        }

        public Type getIdentifierType(String className) throws MappingException {
            return null;
        }

        public String getIdentifierPropertyName(String className) throws MappingException {
            return "";
        }

        public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
            return null;
        }
    }

    public static class FakeTypeContributions
    implements TypeContributions {
        private final TypeConfiguration typeConfiguration;

        public void contributeAttributeConverter(Class<? extends AttributeConverter<?, ?>> converterClass) {
        }

        public FakeTypeContributions(TypeConfiguration typeConfiguration) {
            this.typeConfiguration = typeConfiguration;
        }

        public TypeConfiguration getTypeConfiguration() {
            return this.typeConfiguration;
        }
    }

    public static class FakeFunctionContributions
    implements FunctionContributions {
        private final Dialect dialect;
        private final TypeConfiguration typeConfiguration;
        private final SqmFunctionRegistry functionRegistry;

        public FakeFunctionContributions(Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry) {
            this.dialect = dialect;
            this.typeConfiguration = typeConfiguration;
            this.functionRegistry = functionRegistry;
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public TypeConfiguration getTypeConfiguration() {
            return this.typeConfiguration;
        }

        public SqmFunctionRegistry getFunctionRegistry() {
            return this.functionRegistry;
        }

        public ServiceRegistry getServiceRegistry() {
            return null;
        }
    }

    public static class SupportSubqueryAsLeftHandSideInPredicate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsSubselectAsInPredicateLHS();
        }
    }

    public static class SupportsSubqueryInSelect
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsSubqueryInSelect();
        }
    }

    public static class SupportsUnicodeNClob
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            SybaseASEDialect aseDialect;
            return !(dialect instanceof SybaseASEDialect) || (aseDialect = (SybaseASEDialect)dialect).getDriverKind() == SybaseDriverKind.JTDS;
        }
    }

    public static class SupportsNClob
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getNationalizationSupport() == NationalizationSupport.EXPLICIT;
        }
    }

    public static class SupportsCaseInsensitiveLike
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsCaseInsensitiveLike();
        }
    }

    public static class SupportsUpsertOrMerge
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportsTypedArrays
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getPreferredSqlTypeCodeForArray() == 2003;
        }
    }

    public static class SupportsStructuralArrays
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getPreferredSqlTypeCodeForArray() != -3;
        }
    }

    public static class SupportsStandardArrays
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsStandardArrays();
        }
    }

    public static class SupportsCommentOn
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsCommentOn();
        }
    }

    public static class IsPgJdbc
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof PostgreSQLDialect && ((PostgreSQLDialect)dialect).getDriverKind() == PostgreSQLDriverKind.PG_JDBC;
        }
    }

    public static class IsJtds
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof SybaseDialect && ((SybaseDialect)dialect).getDriverKind() == SybaseDriverKind.JTDS;
        }
    }

    public static class SupportsArrayTrim
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_trim");
        }
    }

    public static class SupportsArrayToString
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_to_string");
        }
    }

    public static class SupportsArraySlice
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_slice");
        }
    }

    public static class SupportsArraySet
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_set");
        }
    }

    public static class SupportsArrayReplace
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_replace");
        }
    }

    public static class SupportsArrayRemove
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_remove");
        }
    }

    public static class SupportsArrayRemoveIndex
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_remove_index");
        }
    }

    public static class SupportsArrayPrepend
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_prepend");
        }
    }

    public static class SupportsArrayPosition
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_position");
        }
    }

    public static class SupportsArrayPositions
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_positions");
        }
    }

    public static class SupportsArrayLength
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_length");
        }
    }

    public static class SupportsArrayIntersects
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_intersects");
        }
    }

    public static class SupportsArrayIncludes
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_includes");
        }
    }

    public static class SupportsArrayGet
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_get");
        }
    }

    public static class SupportsArrayFill
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_fill");
        }
    }

    public static class SupportsArrayContains
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_contains");
        }
    }

    public static class SupportsArrayConstructor
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array");
        }
    }

    public static class SupportsArrayConcat
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_concat");
        }
    }

    public static class SupportsArrayAppend
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_append");
        }
    }

    public static class SupportsArrayAgg
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "array_agg");
        }
    }

    public static class SupportsXmlTable
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesSetReturningFunction(dialect, "xmltable");
        }
    }

    public static class SupportsJsonTable
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesSetReturningFunction(dialect, "json_table");
        }
    }

    public static class SupportsGenerateSeries
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesSetReturningFunction(dialect, "generate_series");
        }
    }

    public static class SupportsUnnest
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesSetReturningFunction(dialect, "unnest");
        }
    }

    public static class SupportsXmlagg
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "xmlagg");
        }
    }

    public static class SupportsXmlexists
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "xmlexists");
        }
    }

    public static class SupportsXmlquery
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "xmlquery");
        }
    }

    public static class SupportsXmlpi
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "xmlpi");
        }
    }

    public static class SupportsXmlconcat
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "xmlconcat");
        }
    }

    public static class SupportsXmlforest
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "xmlforest");
        }
    }

    public static class SupportsXmlcomment
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "xmlcomment");
        }
    }

    public static class SupportsXmlelement
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "xmlelement");
        }
    }

    public static class SupportsJsonArrayInsert
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_array_insert");
        }
    }

    public static class SupportsJsonArrayAppend
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_array_append");
        }
    }

    public static class SupportsJsonMergepatch
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_mergepatch");
        }
    }

    public static class SupportsJsonInsert
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_insert");
        }
    }

    public static class SupportsJsonReplace
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_replace");
        }
    }

    public static class SupportsJsonRemove
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_remove");
        }
    }

    public static class SupportsJsonSet
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_set");
        }
    }

    public static class SupportsJsonObjectAgg
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_objectagg") && !(dialect instanceof HSQLDialect);
        }
    }

    public static class SupportsJsonArrayAgg
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_arrayagg");
        }
    }

    public static class SupportsJsonValueErrorBehavior
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_value") && !(dialect instanceof H2Dialect) && !(dialect instanceof MariaDBDialect) && !(dialect instanceof CockroachDialect) && (!(dialect instanceof PostgreSQLDialect) || dialect.getVersion().isSameOrAfter(17));
        }
    }

    public static class SupportsJsonObject
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_object");
        }
    }

    public static class SupportsJsonArray
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_array");
        }
    }

    public static class SupportsJsonExists
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_exists");
        }
    }

    public static class SupportsJsonQueryNestedPath
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_query") && !(dialect instanceof SQLServerDialect) && !(dialect instanceof H2Dialect) && !(dialect instanceof CockroachDialect);
        }
    }

    public static class SupportsJsonQuery
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_query");
        }
    }

    public static class SupportsJsonValue
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return DialectFeatureChecks.definesFunction(dialect, "json_value");
        }
    }

    public static class SupportsXmlComponentUpdate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                dialect.getAggregateSupport().requiresAggregateCustomWriteExpressionRenderer(2009);
                return true;
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                return false;
            }
        }
    }

    public static class SupportsJsonComponentUpdate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                dialect.getAggregateSupport().requiresAggregateCustomWriteExpressionRenderer(3001);
                return true;
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                return false;
            }
        }
    }

    public static class SupportsXmlAggregate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                return dialect.getAggregateSupport() != null && dialect.getAggregateSupport().aggregateComponentCustomReadExpression("", "", "", "", 2009, (SqlTypedMapping)new SqlTypedMappingImpl("varchar", null, null, null, null, (JdbcMapping)new BasicTypeImpl((JavaType)StringJavaType.INSTANCE, (JdbcType)VarcharJdbcType.INSTANCE)), new TypeConfiguration()) != null;
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                return false;
            }
        }
    }

    public static class SupportsJsonAggregate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                return dialect.getAggregateSupport() != null && dialect.getAggregateSupport().aggregateComponentCustomReadExpression("", "", "", "", 3001, (SqlTypedMapping)new SqlTypedMappingImpl("varchar", null, null, null, null, (JdbcMapping)new BasicTypeImpl((JavaType)StringJavaType.INSTANCE, (JdbcType)VarcharJdbcType.INSTANCE)), new TypeConfiguration()) != null;
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                return false;
            }
        }
    }

    public static class SupportsStructAggregate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                return dialect.getAggregateSupport() != null && dialect.getAggregateSupport().aggregateComponentCustomReadExpression("", "", "", "", 2002, (SqlTypedMapping)new SqlTypedMappingImpl("varchar", null, null, null, null, (JdbcMapping)new BasicTypeImpl((JavaType)StringJavaType.INSTANCE, (JdbcType)VarcharJdbcType.INSTANCE)), new TypeConfiguration()) != null;
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                return false;
            }
        }
    }

    public static class SupportsTruncateTable
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof MySQLDialect || dialect instanceof H2Dialect || dialect instanceof SQLServerDialect || dialect instanceof PostgreSQLDialect || dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof SybaseDialect || dialect instanceof DerbyDialect || dialect instanceof HSQLDialect;
        }
    }

    public static class SupportsRecursiveCtes
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsRecursiveCTE();
        }
    }

    public static class SupportsMedian
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof MySQLDialect && !(dialect instanceof MariaDBDialect) || dialect instanceof SybaseDialect || dialect instanceof DerbyDialect || dialect instanceof FirebirdDialect || dialect instanceof DB2Dialect && ((DB2Dialect)dialect).getDB2Version().isBefore(11));
        }
    }

    public static class SupportsFullJoin
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof H2Dialect) && !(dialect instanceof MySQLDialect) && !(dialect instanceof SybaseDialect) && !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportsSubqueryInOnClause
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof TiDBDialect);
        }
    }

    public static class SupportsFilterClause
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof PostgreSQLDialect;
        }
    }

    public static class SupportsWindowFunctions
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsWindowFunctions() && !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportsHypotheticalSetFunctions
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof H2Dialect || dialect instanceof PostgreSQLDialect || dialect instanceof HANADialect || dialect instanceof CockroachDialect || dialect instanceof DB2Dialect && ((DB2Dialect)dialect).getDB2Version().isSameOrAfter(11) || dialect instanceof OracleDialect || dialect instanceof SpannerDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class SupportsInverseDistributionFunctions
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof H2Dialect || dialect instanceof PostgreSQLDialect || dialect instanceof HANADialect || dialect instanceof CockroachDialect || dialect instanceof DB2Dialect && ((DB2Dialect)dialect).getDB2Version().isSameOrAfter(11) || dialect instanceof OracleDialect || dialect instanceof SpannerDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class SupportsStringAggregation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof H2Dialect || dialect instanceof HSQLDialect || dialect instanceof MySQLDialect || dialect instanceof PostgreSQLDialect || dialect instanceof HANADialect || dialect instanceof CockroachDialect || dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof SpannerDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class ForceLobAsLastValue
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.forceLobAsLastValue();
        }
    }

    public static class UsesStandardCurrentTimestampFunction
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsStandardCurrentTimestampFunction();
        }
    }

    public static class CurrentTimestampHasMicrosecondPrecision
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !dialect.currentTimestamp().contains("6");
        }
    }

    public static class SupportNoWait
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsNoWait();
        }
    }

    public static class SupportsOrderByInCorrelatedSubquery
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsOrderByInSubquery() && !(dialect instanceof HANADialect);
        }
    }

    public static class SupportsOrderByInSubquery
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsOrderByInSubquery();
        }
    }

    public static class SupportsTruncateThroughCast
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                dialect.appendDatetimeFormat((SqlAppender)new StringBuilderSqlAppender(), "");
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    public static class SupportsFormat
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                dialect.appendDatetimeFormat((SqlAppender)new StringBuilderSqlAppender(), "");
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    public static class SupportsValuesListForInsert
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsValuesListForInsert();
        }
    }

    public static class SupportsTemporaryTable
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsTemporaryTables();
        }
    }

    public static class SupportsRepeat
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof DerbyDialect) && !(dialect instanceof InformixDialect);
        }
    }

    public static class SupportsReplace
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportsCharCodeConversion
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportsUnion
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsUnionAll();
        }
    }

    public static class SupportsWithTies
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsFetchClause(FetchClauseType.ROWS_WITH_TIES) || dialect.supportsWindowFunctions();
        }
    }

    public static class SupportsOffsetInSubquery
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsOffsetInSubquery();
        }
    }

    public static class SupportsTimezoneTypes
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getTimeZoneSupport() == TimeZoneSupport.NATIVE;
        }
    }

    public static class SupportsGroupByGroupingSets
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof PostgreSQLDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class SupportsGroupByRollup
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof PostgreSQLDialect || dialect instanceof SQLServerDialect || dialect instanceof DerbyDialect || dialect instanceof MySQLDialect && !(dialect instanceof TiDBDialect) || dialect instanceof MariaDBDialect;
        }
    }

    public static class SupportsPadWithChar
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportNullPrecedence
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsNullPrecedence();
        }
    }

    public static class SupportDropConstraints
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.dropConstraints();
        }
    }

    public static class SupportPartitionBy
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsPartitionBy();
        }
    }

    public static class SupportFollowOnLocking
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.useFollowOnLocking(null, null);
        }
    }

    public static class SupportCatalogCreation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.canCreateCatalog();
        }
    }

    public static class SupportSchemaCreation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.canCreateSchema();
        }
    }

    public static class DoubleQuoteQuoting
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return '\"' == dialect.openQuote() && '\"' == dialect.closeQuote();
        }
    }

    public static class SupportsSkipLocked
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsSkipLocked();
        }
    }

    public static class SupportsLockTimeouts
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsLockTimeouts();
        }
    }

    public static class SupportsLobValueChangePropogation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsLobValueChangePropagation();
        }
    }

    public static class SupportsExistsInSelectCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsExistsInSelect();
        }
    }

    public static class DoesRepeatableReadCauseReadersToBlockWritersCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.doesRepeatableReadCauseReadersToBlockWriters();
        }
    }

    public static class DoesReadCommittedCauseWritersToBlockReadersCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.doesReadCommittedCauseWritersToBlockReaders();
        }
    }

    public static class SupportsJdbcDriverProxying
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof DB2Dialect) && !(dialect instanceof DerbyDialect) && !(dialect instanceof FirebirdDialect);
        }
    }

    public static class SupportsRowValueConstructorSyntaxCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof HANADialect || dialect instanceof CockroachDialect || dialect instanceof MySQLDialect || dialect instanceof PostgreSQLDialect;
        }
    }

    public static class HasSelfReferentialForeignKeyBugCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.hasSelfReferentialForeignKeyBug();
        }
    }

    public static class SupportLimitAndOffsetCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getLimitHandler().supportsLimit() && dialect.getLimitHandler().supportsLimitOffset();
        }
    }

    public static class SupportLimitCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getLimitHandler().supportsLimit();
        }
    }

    public static class SupportsSubqueryAsLeftHandSideInPredicate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsSubselectAsInPredicateLHS();
        }
    }

    public static class SupportsUnboundedLobLocatorMaterializationCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsExpectedLobUsagePattern() && dialect.supportsUnboundedLobLocatorMaterialization();
        }
    }

    public static class SupportsCircularCascadeDeleteCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsCircularCascadeDeleteConstraints();
        }
    }

    public static class SupportsCascadeDeleteCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsCascadeDelete();
        }
    }

    public static class SupportsResultSetPositioningOnForwardOnlyCursorCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsResultSetPositionQueryMethodsOnForwardOnlyCursor();
        }
    }

    public static class SupportsNoColumnInsert
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsNoColumnsInsert();
        }
    }

    public static class SupportsColumnCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsColumnCheck();
        }
    }

    public static class SupportsIdentityColumns
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getIdentityColumnSupport().supportsIdentityColumns();
        }
    }

    public static class UsesInputStreamToInsertBlob
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.useInputStreamToInsertBlob();
        }
    }

    public static class SupportsNationalizedDataTypes
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getNationalizationSupport() == NationalizationSupport.EXPLICIT;
        }
    }

    public static class SupportsNationalizedData
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getNationalizationSupport() != NationalizationSupport.UNSUPPORTED;
        }
    }

    public static class SupportsExpectedLobUsagePattern
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsExpectedLobUsagePattern();
        }
    }

    public static class SupportsSequences
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getSequenceSupport().supportsSequences();
        }
    }
}

