/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jta;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.testing.jta.JtaAwareConnectionProviderImpl;
import org.hibernate.testing.jta.TestingJtaPlatformImpl;
import org.hibernate.testing.orm.junit.SettingConfiguration;
import org.hibernate.testing.util.ServiceRegistryUtil;

public final class TestingJtaBootstrap
implements SettingConfiguration.Configurer {
    public static final TestingJtaBootstrap INSTANCE = new TestingJtaBootstrap();

    public static void prepare(Map<String, Object> configValues) {
        configValues.put("hibernate.transaction.jta.platform", (Object)TestingJtaPlatformImpl.INSTANCE);
        configValues.put("hibernate.connection.provider_class", JtaAwareConnectionProviderImpl.class.getName());
        configValues.put("hibernate.connection.provider_disables_autocommit", Boolean.TRUE);
        configValues.put("javax.persistence.transactionType", "JTA");
    }

    public static void prepare(StandardServiceRegistryBuilder registryBuilder) {
        registryBuilder.applySetting("hibernate.transaction.coordinator_class", (Object)"jta");
        registryBuilder.applySetting("hibernate.transaction.jta.platform", (Object)TestingJtaPlatformImpl.INSTANCE);
        registryBuilder.applySetting("hibernate.connection.provider_class", (Object)JtaAwareConnectionProviderImpl.class.getName());
        registryBuilder.applySetting("hibernate.connection.provider_disables_autocommit", (Object)Boolean.TRUE);
        registryBuilder.applySetting("javax.persistence.transactionType", (Object)"JTA");
    }

    public static StandardServiceRegistryBuilder prepare() {
        StandardServiceRegistryBuilder registryBuilder = ServiceRegistryUtil.serviceRegistryBuilder();
        TestingJtaBootstrap.prepare(registryBuilder);
        return registryBuilder;
    }

    @Override
    public void applySettings(StandardServiceRegistryBuilder registryBuilder) {
        registryBuilder.applySetting("hibernate.transaction.coordinator_class", (Object)"jta");
        TestingJtaBootstrap.prepare(registryBuilder);
    }
}

