/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.library;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.testing.orm.domain.library.Person;

@Entity
public class Book {
    @Id
    private Integer id;
    private String name;
    private String isbn;
    @ManyToMany
    @JoinTable(name="book_authors", joinColumns={@JoinColumn(name="book_fk")}, inverseJoinColumns={@JoinColumn(name="author_fk")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    Set<Person> authors;
    @ManyToMany
    @JoinTable(name="book_editors", joinColumns={@JoinColumn(name="book_fk")}, inverseJoinColumns={@JoinColumn(name="editor_fk")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    Set<Person> editors;

    protected Book() {
    }

    public Book(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIsbn() {
        return this.isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public Set<Person> getAuthors() {
        return this.authors;
    }

    public void setAuthors(Set<Person> authors) {
        this.authors = authors;
    }

    public void addAuthor(Person author) {
        if (this.authors == null) {
            this.authors = new HashSet<Person>();
        }
        this.authors.add(author);
    }

    public Set<Person> getEditors() {
        return this.editors;
    }

    public void setEditors(Set<Person> editors) {
        this.editors = editors;
    }

    public void addEditor(Person editor) {
        if (this.editors == null) {
            this.editors = new HashSet<Person>();
        }
        this.editors.add(editor);
    }
}

