/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.testing.memory.MemoryAllocationSnapshot;
import org.hibernate.testing.memory.MemoryAllocationSnapshotter;

final class HotspotTotalThreadBytesSnapshotter
implements MemoryAllocationSnapshotter {
    private static final @Nullable HotspotTotalThreadBytesSnapshotter INSTANCE;
    private static final Method GET_TOTAL_THREAD_ALLOCATED_BYTES;
    private final ThreadMXBean threadMXBean;

    public static @Nullable HotspotTotalThreadBytesSnapshotter getInstance() {
        return INSTANCE;
    }

    @Override
    public MemoryAllocationSnapshot snapshot() {
        try {
            return new GlobalMemoryAllocationSnapshot((Long)GET_TOTAL_THREAD_ALLOCATED_BYTES.invoke((Object)this.threadMXBean, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    HotspotTotalThreadBytesSnapshotter(ThreadMXBean threadMXBean) {
        this.threadMXBean = threadMXBean;
    }

    public ThreadMXBean threadMXBean() {
        return this.threadMXBean;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HotspotTotalThreadBytesSnapshotter that = (HotspotTotalThreadBytesSnapshotter)obj;
        return Objects.equals(this.threadMXBean, that.threadMXBean);
    }

    public int hashCode() {
        return Objects.hash(this.threadMXBean);
    }

    public String toString() {
        return "HotspotTotalThreadBytesSnapshotter[threadMXBean=" + String.valueOf(this.threadMXBean) + "]";
    }

    static {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Method method = null;
        try {
            Class<?> hotspotInterface = Class.forName("com.sun.management.ThreadMXBean");
            try {
                method = hotspotInterface.getMethod("getTotalThreadAllocatedBytes", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!hotspotInterface.isInstance(threadMXBean)) {
                threadMXBean = (ThreadMXBean)ManagementFactory.getPlatformMXBean(hotspotInterface);
            }
        }
        catch (Throwable hotspotInterface) {
            // empty catch block
        }
        GET_TOTAL_THREAD_ALLOCATED_BYTES = method;
        HotspotTotalThreadBytesSnapshotter instance = null;
        if (method != null && threadMXBean != null) {
            try {
                instance = new HotspotTotalThreadBytesSnapshotter(threadMXBean);
                instance.snapshot();
            }
            catch (Exception e) {
                instance = null;
            }
        }
        INSTANCE = instance;
    }

    static final class GlobalMemoryAllocationSnapshot
    implements MemoryAllocationSnapshot {
        private final long allocatedBytes;

        GlobalMemoryAllocationSnapshot(long allocatedBytes) {
            if (allocatedBytes == -1L) {
                throw new IllegalArgumentException("getTotalThreadAllocatedBytes is disabled");
            }
            this.allocatedBytes = allocatedBytes;
        }

        @Override
        public long difference(MemoryAllocationSnapshot before) {
            GlobalMemoryAllocationSnapshot other = (GlobalMemoryAllocationSnapshot)before;
            return Math.max(this.allocatedBytes - other.allocatedBytes, 0L);
        }

        public long allocatedBytes() {
            return this.allocatedBytes;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            GlobalMemoryAllocationSnapshot that = (GlobalMemoryAllocationSnapshot)obj;
            return this.allocatedBytes == that.allocatedBytes;
        }

        public int hashCode() {
            return Objects.hash(this.allocatedBytes);
        }

        public String toString() {
            return "GlobalMemoryAllocationSnapshot[allocatedBytes=" + this.allocatedBytes + "]";
        }
    }
}

