/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.bytecode.enhancement.extension;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstancePreConstructCallback;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;

public class BytecodeEnhancementExtension
implements TestInstancePreConstructCallback,
TestInstancePreDestroyCallback {
    private ClassLoader originalClassLoader;

    public void preConstructTestInstance(TestInstanceFactoryContext testInstanceFactoryContext, ExtensionContext extensionContext) {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(testInstanceFactoryContext.getTestClass().getClassLoader());
    }

    public void preDestroyTestInstance(ExtensionContext extensionContext) {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }
}

