/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.util.uuid;

import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.service.ServiceRegistry;

public class IdGeneratorCreationContext
implements CustomIdGeneratorCreationContext {
    private final ServiceRegistry serviceRegistry;
    private final MetadataImplementor domainModel;
    private final RootClass entityMapping;

    public IdGeneratorCreationContext(ServiceRegistry serviceRegistry, MetadataImplementor domainModel, RootClass entityMapping) {
        this.serviceRegistry = serviceRegistry;
        this.domainModel = domainModel;
        this.entityMapping = entityMapping;
        assert (entityMapping.getIdentifierProperty() != null);
    }

    public IdGeneratorCreationContext(MetadataImplementor domainModel, RootClass entityMapping) {
        this((ServiceRegistry)domainModel.getMetadataBuildingOptions().getServiceRegistry(), domainModel, entityMapping);
    }

    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.domainModel.getMetadataBuildingOptions().getIdentifierGeneratorFactory();
    }

    public RootClass getRootClass() {
        return this.entityMapping;
    }

    public Database getDatabase() {
        return this.domainModel.getDatabase();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.domainModel.getMetadataBuildingOptions().getServiceRegistry();
    }

    public String getDefaultCatalog() {
        return "";
    }

    public String getDefaultSchema() {
        return "";
    }

    public PersistentClass getPersistentClass() {
        return this.entityMapping;
    }

    public Property getProperty() {
        return this.entityMapping.getIdentifierProperty();
    }
}

