/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.testing.memory.MemoryAllocationSnapshot;
import org.hibernate.testing.memory.MemoryAllocationSnapshotter;

final class HotspotPerThreadAllocationSnapshotter
implements MemoryAllocationSnapshotter {
    private static final @Nullable HotspotPerThreadAllocationSnapshotter INSTANCE;
    private static final Method GET_THREAD_ALLOCATED_BYTES;
    private final ThreadMXBean threadMXBean;

    public static @Nullable HotspotPerThreadAllocationSnapshotter getInstance() {
        return INSTANCE;
    }

    @Override
    public MemoryAllocationSnapshot snapshot() {
        long[] threadIds = this.threadMXBean.getAllThreadIds();
        try {
            return new PerThreadMemoryAllocationSnapshot(threadIds, (long[])GET_THREAD_ALLOCATED_BYTES.invoke((Object)this.threadMXBean, new Object[]{threadIds}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    HotspotPerThreadAllocationSnapshotter(ThreadMXBean threadMXBean) {
        this.threadMXBean = threadMXBean;
    }

    public ThreadMXBean threadMXBean() {
        return this.threadMXBean;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HotspotPerThreadAllocationSnapshotter that = (HotspotPerThreadAllocationSnapshotter)obj;
        return Objects.equals(this.threadMXBean, that.threadMXBean);
    }

    public int hashCode() {
        return Objects.hash(this.threadMXBean);
    }

    public String toString() {
        return "HotspotPerThreadAllocationSnapshotter[threadMXBean=" + String.valueOf(this.threadMXBean) + "]";
    }

    static {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Method method = null;
        try {
            Class<?> hotspotInterface = Class.forName("com.sun.management.ThreadMXBean");
            try {
                method = hotspotInterface.getMethod("getThreadAllocatedBytes", long[].class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!hotspotInterface.isInstance(threadMXBean)) {
                threadMXBean = (ThreadMXBean)ManagementFactory.getPlatformMXBean(hotspotInterface);
            }
        }
        catch (Throwable hotspotInterface) {
            // empty catch block
        }
        GET_THREAD_ALLOCATED_BYTES = method;
        HotspotPerThreadAllocationSnapshotter instance = null;
        if (method != null && threadMXBean != null) {
            try {
                instance = new HotspotPerThreadAllocationSnapshotter(threadMXBean);
                instance.snapshot();
            }
            catch (Exception e) {
                instance = null;
            }
        }
        INSTANCE = instance;
    }

    static final class PerThreadMemoryAllocationSnapshot
    implements MemoryAllocationSnapshot {
        private final long[] threadIds;
        private final long[] threadAllocatedBytes;

        PerThreadMemoryAllocationSnapshot(long[] threadIds, long[] threadAllocatedBytes) {
            this.threadIds = threadIds;
            this.threadAllocatedBytes = threadAllocatedBytes;
        }

        public long[] threadIds() {
            return this.threadIds;
        }

        public long[] threadAllocatedBytes() {
            return this.threadAllocatedBytes;
        }

        @Override
        public long difference(MemoryAllocationSnapshot before) {
            PerThreadMemoryAllocationSnapshot other = (PerThreadMemoryAllocationSnapshot)before;
            HashMap<Long, Integer> previousThreadIdToIndexMap = new HashMap<Long, Integer>();
            for (int i = 0; i < other.threadIds.length; ++i) {
                previousThreadIdToIndexMap.put(other.threadIds[i], i);
            }
            long allocatedBytes = 0L;
            for (int i = 0; i < this.threadIds.length; ++i) {
                allocatedBytes += this.threadAllocatedBytes[i];
                Integer previousThreadIndex = (Integer)previousThreadIdToIndexMap.get(this.threadIds[i]);
                if (previousThreadIndex == null) continue;
                allocatedBytes -= other.threadAllocatedBytes[previousThreadIndex];
            }
            return allocatedBytes;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PerThreadMemoryAllocationSnapshot that = (PerThreadMemoryAllocationSnapshot)obj;
            return Objects.equals(this.threadIds, that.threadIds) && Objects.equals(this.threadAllocatedBytes, that.threadAllocatedBytes);
        }

        public int hashCode() {
            return Objects.hash(this.threadIds, this.threadAllocatedBytes);
        }

        public String toString() {
            return "PerThreadMemoryAllocationSnapshot[threadIds=" + String.valueOf(this.threadIds) + ", threadAllocatedBytes=" + String.valueOf(this.threadAllocatedBytes) + "]";
        }
    }
}

