/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class ReflectionUtil {
    public static Field getField(Class clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class superClass = clazz.getSuperclass();
            if (!clazz.equals(superClass)) {
                return ReflectionUtil.getField(superClass, name);
            }
            throw new IllegalArgumentException("Class " + String.valueOf(clazz) + " does not contain a " + name + " field", e);
        }
    }

    public static <T> T getFieldValue(Object target, String name) {
        try {
            Field field = target.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(target);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Class " + String.valueOf(target.getClass()) + " does not contain a " + name + " field", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot set field " + name, e);
        }
    }

    public static <T> T getStaticFieldValue(Class<?> target, String name) {
        try {
            Field field = ReflectionUtil.getField(target, name);
            return (T)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot set field " + name, e);
        }
    }

    public static void setField(Object target, Field field, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Field " + String.valueOf(field) + " could not be set", e);
        }
    }

    public static void setField(Object target, String fieldName, Object value) {
        try {
            Field field = ReflectionUtil.getField(target.getClass(), fieldName);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Field " + fieldName + " could not be set", e);
        }
    }

    public static void setStaticField(Class<?> target, String fieldName, Object value) {
        try {
            Field field = ReflectionUtil.getField(target, fieldName);
            field.set(null, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Field " + fieldName + " could not be set", e);
        }
    }

    public static <T> T newInstance(Supplier<Constructor<T>> constructorSupplier, Object ... args) {
        try {
            Constructor<T> constructor = constructorSupplier.get();
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Constructor could not be called", e);
        }
    }

    public static <T> T newInstance(String className) {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Constructor could not be called", e);
        }
    }

    public static Method getSetter(Object target, String property, Class<?> parameterType) {
        String setterMethodName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method setter = ReflectionUtil.getMethod(target, setterMethodName, parameterType);
        setter.setAccessible(true);
        return setter;
    }

    public static Method getMethod(Object target, String methodName, Class ... parameterTypes) {
        try {
            return target.getClass().getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void setProperty(Object target, String property, Object parameter) {
        Method setter = ReflectionUtil.getSetter(target, property, parameter.getClass());
        try {
            setter.invoke(target, parameter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

