/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.bytecode.enhancement.extension.engine;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.hibernate.testing.bytecode.enhancement.extension.BytecodeEnhanced;
import org.hibernate.testing.bytecode.enhancement.extension.engine.BytecodeEnhancedClassUtils;
import org.hibernate.testing.bytecode.enhancement.extension.engine.BytecodeEnhancedEngineDescriptor;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.JupiterTestEngine;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestTemplateTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class BytecodeEnhancedTestEngine
extends HierarchicalTestEngine<JupiterEngineExecutionContext> {
    public String getId() {
        return "bytecode-enhanced-engine";
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        BytecodeEnhancedEngineDescriptor engineDescriptor = new BytecodeEnhancedEngineDescriptor((JupiterEngineDescriptor)new JupiterTestEngine().discover(discoveryRequest, uniqueId));
        for (TestDescriptor testDescriptor : new HashSet(engineDescriptor.getChildren())) {
            if (!(testDescriptor instanceof ClassBasedTestDescriptor)) continue;
            try {
                ClassBasedTestDescriptor descriptor = (ClassBasedTestDescriptor)testDescriptor;
                Optional bytecodeEnhanced = AnnotationUtils.findAnnotation((AnnotatedElement)descriptor.getTestClass(), BytecodeEnhanced.class);
                if (bytecodeEnhanced.isPresent()) {
                    Map<Object, Class<?>> classes;
                    TestDescriptor parent = (TestDescriptor)descriptor.getParent().orElseThrow(IllegalStateException::new);
                    Class klass = descriptor.getTestClass();
                    JupiterConfiguration jc = ((JupiterEngineDescriptor)parent).getConfiguration();
                    String[] testEnhancedClasses = (String[])Arrays.stream(((BytecodeEnhanced)bytecodeEnhanced.get()).testEnhancedClasses()).map(Class::getName).toArray(String[]::new);
                    HashSet children = new HashSet(descriptor.getChildren());
                    if (!((BytecodeEnhanced)bytecodeEnhanced.get()).runNotEnhancedAsWell()) {
                        descriptor.removeFromHierarchy();
                    }
                    if ((classes = BytecodeEnhancedClassUtils.enhanceTestClass(klass)).size() == 1) {
                        this.replaceWithEnhanced(classes.values().iterator().next(), descriptor, jc, children, parent, testEnhancedClasses);
                    } else {
                        for (Map.Entry<Object, Class<?>> entry : classes.entrySet()) {
                            this.replaceWithEnhanced(entry.getValue(), descriptor, jc, children, parent, testEnhancedClasses, entry.getKey());
                        }
                    }
                    this.addEnhancementCheck(false, testEnhancedClasses, descriptor, jc);
                    continue;
                }
                testDescriptor.removeFromHierarchy();
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return engineDescriptor;
    }

    private void addEnhancementCheck(boolean enhance, String[] testEnhancedClasses, ClassBasedTestDescriptor descriptor, JupiterConfiguration jc) {
        if (testEnhancedClasses.length > 0) {
            descriptor.addChild((TestDescriptor)new EnhancementWorkedCheckMethodTestDescriptor(UniqueId.forEngine((String)this.getId()).append("class", descriptor.getTestClass().getName()), descriptor.getTestClass(), jc, enhance, testEnhancedClasses));
        }
    }

    private void replaceWithEnhanced(Class<?> enhanced, ClassBasedTestDescriptor descriptor, JupiterConfiguration jc, Set<? extends TestDescriptor> children, TestDescriptor parent, String[] testEnhancedClasses) throws NoSuchMethodException {
        this.replaceWithEnhanced(enhanced, descriptor, jc, children, parent, testEnhancedClasses, null);
    }

    private void replaceWithEnhanced(Class<?> enhanced, ClassBasedTestDescriptor descriptor, JupiterConfiguration jc, Set<? extends TestDescriptor> children, TestDescriptor parent, String[] testEnhancedClasses, Object enhancementContextId) throws NoSuchMethodException {
        JupiterConfiguration configuration = (JupiterConfiguration)Proxy.newProxyInstance(BytecodeEnhancedTestEngine.class.getClassLoader(), new Class[]{JupiterConfiguration.class}, (InvocationHandler)new JupiterConfigurationInvocationHandler(jc, enhancementContextId));
        ClassTestDescriptor updated = new ClassTestDescriptor(this.convertUniqueId(descriptor.getUniqueId(), enhancementContextId), enhanced, configuration);
        for (TestDescriptor testDescriptor : children) {
            Method testMethod;
            if (testDescriptor instanceof TestMethodTestDescriptor) {
                testMethod = ((TestMethodTestDescriptor)testDescriptor).getTestMethod();
                updated.addChild((TestDescriptor)new TestMethodTestDescriptor(this.convertUniqueId(testDescriptor.getUniqueId(), enhancementContextId), updated.getTestClass(), this.findMethodReplacement(updated, testMethod), configuration));
            }
            if (!(testDescriptor instanceof TestTemplateTestDescriptor)) continue;
            testMethod = ((TestTemplateTestDescriptor)testDescriptor).getTestMethod();
            updated.addChild((TestDescriptor)new TestTemplateTestDescriptor(this.convertUniqueId(testDescriptor.getUniqueId(), enhancementContextId), updated.getTestClass(), this.findMethodReplacement(updated, testMethod), configuration));
        }
        this.addEnhancementCheck(true, testEnhancedClasses, (ClassBasedTestDescriptor)updated, configuration);
        parent.addChild((TestDescriptor)updated);
    }

    private UniqueId convertUniqueId(UniqueId id, Object enhancementContextId) {
        UniqueId uniqueId = UniqueId.forEngine((String)this.getId()).append("Enhanced", enhancementContextId == null ? "true" : Objects.toString(enhancementContextId));
        List segments = id.getSegments();
        for (int i = 1; i < segments.size(); ++i) {
            UniqueId.Segment segment = (UniqueId.Segment)segments.get(i);
            uniqueId = uniqueId.append(segment);
        }
        return uniqueId;
    }

    private Method findMethodReplacement(ClassTestDescriptor updated, Method testMethod) throws NoSuchMethodException {
        String name = testMethod.getDeclaringClass().getName();
        Class testClass = updated.getTestClass();
        while (!testClass.getName().equals(name)) {
            if (!Object.class.equals(testClass = testClass.getSuperclass())) continue;
            throw new IllegalStateException("Wasn't able to find a test method " + testMethod);
        }
        return testClass.getDeclaredMethod(testMethod.getName(), testMethod.getParameterTypes());
    }

    protected JupiterEngineExecutionContext createExecutionContext(ExecutionRequest request) {
        try {
            Class<?> storeFacadeClass = Class.forName("org.junit.jupiter.engine.descriptor.LauncherStoreFacade");
            Method getStore = ExecutionRequest.class.getMethod("getStore", new Class[0]);
            Constructor<?> storeConstructor = storeFacadeClass.getConstructor(getStore.getReturnType());
            Constructor constructor = JupiterEngineExecutionContext.class.getConstructor(EngineExecutionListener.class, JupiterConfiguration.class, storeFacadeClass);
            return (JupiterEngineExecutionContext)constructor.newInstance(request.getEngineExecutionListener(), this.getJupiterConfiguration(request), storeConstructor.newInstance(getStore.invoke((Object)request, new Object[0])));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return new JupiterEngineExecutionContext(request.getEngineExecutionListener(), this.getJupiterConfiguration(request));
        }
    }

    private JupiterConfiguration getJupiterConfiguration(ExecutionRequest request) {
        JupiterEngineDescriptor engineDescriptor = (JupiterEngineDescriptor)request.getRootTestDescriptor();
        return engineDescriptor.getConfiguration();
    }

    public Optional<String> getGroupId() {
        return Optional.of("org.junit.jupiter");
    }

    public Optional<String> getArtifactId() {
        return Optional.of("junit-jupiter-engine");
    }

    private static class EnhancementWorkedCheckMethodTestDescriptor
    extends TestMethodTestDescriptor {
        private final boolean enhanced;
        private final String[] classes;
        private static final Method METHOD_ENHANCED;
        private static final Method METHOD_NOT_ENHANCED;

        public EnhancementWorkedCheckMethodTestDescriptor(UniqueId uniqueId, Class<?> testClass, JupiterConfiguration configuration, boolean enhanced, String[] classes) {
            super(EnhancementWorkedCheckMethodTestDescriptor.prepareId(uniqueId, EnhancementWorkedCheckMethodTestDescriptor.testMethod(enhanced)), testClass, EnhancementWorkedCheckMethodTestDescriptor.testMethod(enhanced), configuration);
            this.enhanced = enhanced;
            this.classes = classes;
        }

        private static Method testMethod(boolean enhanced) {
            return enhanced ? METHOD_ENHANCED : METHOD_NOT_ENHANCED;
        }

        public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
            ExtensionContext extensionContext = context.getExtensionContext();
            ThrowableCollector throwableCollector = context.getThrowableCollector();
            throwableCollector.execute(() -> {
                Object instance = extensionContext.getRequiredTestInstance();
                for (String className : this.classes) {
                    EnhancementWorkedCheckMethodTestDescriptor.assertEnhancementWorked(className, this.enhanced, instance);
                }
            });
            return context;
        }

        private static void assertEntityClassesWereEnhanced() {
        }

        private static void assertEntityClassesWereNotEnhanced() {
        }

        private static void assertEnhancementWorked(String className, boolean enhanced, Object testClassInstance) {
            try {
                Class<?> loaded = testClassInstance.getClass().getClassLoader().loadClass(className);
                if (enhanced) {
                    Assertions.assertThat((Object[])loaded.getDeclaredMethods()).extracting(Method::getName).anyMatch(name -> name.startsWith("$$_hibernate_"));
                } else {
                    Assertions.assertThat((Object[])loaded.getDeclaredMethods()).extracting(Method::getName).noneMatch(name -> name.startsWith("$$_hibernate_"));
                }
            }
            catch (ClassNotFoundException e) {
                org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
            }
        }

        private static UniqueId prepareId(UniqueId uniqueId, Method method) {
            return uniqueId.append("method", method.getName());
        }

        static {
            try {
                METHOD_ENHANCED = EnhancementWorkedCheckMethodTestDescriptor.class.getDeclaredMethod("assertEntityClassesWereEnhanced", new Class[0]);
                METHOD_NOT_ENHANCED = EnhancementWorkedCheckMethodTestDescriptor.class.getDeclaredMethod("assertEntityClassesWereNotEnhanced", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class DisplayNameGeneratorInvocationHandler
    implements InvocationHandler {
        private final DisplayNameGenerator delegate;
        private final Object id;

        private DisplayNameGeneratorInvocationHandler(DisplayNameGenerator delegate, Object id) {
            this.delegate = delegate;
            this.id = id;
        }

        private String prefix() {
            return "Enhanced" + (String)(this.id == null ? "" : "[" + this.id + "]") + ":";
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = method.invoke((Object)this.delegate, args);
            if (method.getDeclaringClass() == DisplayNameGenerator.class) {
                return this.prefix() + result;
            }
            return result;
        }
    }

    private static class JupiterConfigurationInvocationHandler
    implements InvocationHandler {
        private final JupiterConfiguration configuration;
        private final DisplayNameGenerator displayNameGenerator;

        private JupiterConfigurationInvocationHandler(JupiterConfiguration configuration, Object id) {
            this.configuration = configuration;
            this.displayNameGenerator = (DisplayNameGenerator)Proxy.newProxyInstance(BytecodeEnhancedTestEngine.class.getClassLoader(), new Class[]{DisplayNameGenerator.class}, (InvocationHandler)new DisplayNameGeneratorInvocationHandler(configuration.getDefaultDisplayNameGenerator(), id));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getDefaultDisplayNameGenerator".equals(method.getName())) {
                return this.displayNameGenerator;
            }
            return method.invoke((Object)this.configuration, args);
        }
    }

    public static class Context
    implements EngineExecutionContext {
        private final ExecutionRequest request;

        public Context(ExecutionRequest request) {
            this.request = request;
        }
    }
}

