/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.logger;

import java.util.Set;
import org.hibernate.testing.logger.LogInspectionHelper;
import org.hibernate.testing.logger.LogListener;
import org.hibernate.testing.logger.TriggerOnPrefixLogListener;
import org.hibernate.testing.logger.Triggerable;
import org.jboss.logging.BasicLogger;
import org.junit.rules.ExternalResource;

public final class LoggerInspectionRule
extends ExternalResource {
    private final BasicLogger log;

    public LoggerInspectionRule(BasicLogger log) {
        this.log = log;
    }

    protected void before() throws Throwable {
    }

    protected void after() {
        LogInspectionHelper.clearAllListeners(this.log);
    }

    public void registerListener(LogListener listener) {
        LogInspectionHelper.registerListener(listener, this.log);
    }

    public Triggerable watchForLogMessages(String prefix) {
        TriggerOnPrefixLogListener listener = new TriggerOnPrefixLogListener(prefix);
        this.registerListener(listener);
        return listener;
    }

    public Triggerable watchForLogMessages(Set<String> prefixes) {
        TriggerOnPrefixLogListener listener = new TriggerOnPrefixLogListener(prefixes);
        this.registerListener(listener);
        return listener;
    }
}

