/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.userguide;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKey;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SqlResultSetMapping;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.testing.orm.domain.userguide.Call;
import org.hibernate.testing.orm.domain.userguide.Person;
import org.hibernate.testing.orm.domain.userguide.PersonPhoneCount;
import org.hibernate.testing.orm.domain.userguide.PhoneType;

@NamedQuery(name="get_phone_by_number", query="select p from Phone p where p.number = :number", timeout=1, readOnly=true)
@NamedNativeQuery(name="get_person_phone_count", query="select pr.name AS name, count(*) AS phone_count from Phone p join Person pr ON pr.id = p.person_id group BY pr.name", resultSetMapping="person_phone_count", timeout=1, readOnly=true)
@SqlResultSetMapping(name="person_phone_count", classes={@ConstructorResult(targetClass=PersonPhoneCount.class, columns={@ColumnResult(name="name"), @ColumnResult(name="phone_count")})})
@Entity
public class Phone {
    @Id
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    private Person person;
    @Column(name="phone_number")
    private String number;
    @Enumerated(value=EnumType.STRING)
    @Column(name="phone_type")
    private PhoneType type;
    @OneToMany(mappedBy="phone", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Call> calls = new ArrayList<Call>();
    @OneToMany(mappedBy="phone")
    @MapKey(name="timestamp")
    private Map<LocalDateTime, Call> callHistory = new HashMap<LocalDateTime, Call>();
    @ElementCollection
    private List<LocalDateTime> repairTimestamps = new ArrayList<LocalDateTime>();

    public Phone() {
    }

    public Phone(String number) {
        this.number = number;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public PhoneType getType() {
        return this.type;
    }

    public void setType(PhoneType type) {
        this.type = type;
    }

    public List<Call> getCalls() {
        return this.calls;
    }

    public Map<LocalDateTime, Call> getCallHistory() {
        return this.callHistory;
    }

    public List<LocalDateTime> getRepairTimestamps() {
        return this.repairTimestamps;
    }

    public void addCall(Call call) {
        this.calls.add(call);
        this.callHistory.put(call.getTimestamp(), call);
        call.setPhone(this);
    }
}

