/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.hamcrest;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.testing.hamcrest.CollectionEmptinessMatcher;
import org.hibernate.testing.hamcrest.HasNullElementsMatcher;
import org.hibernate.testing.hamcrest.InitializationCheckMatcher;

public class CollectionMatchers {
    private static final CollectionEmptinessMatcher IS_EMPTY = new CollectionEmptinessMatcher(true);
    private static final CollectionEmptinessMatcher IS_NOT_EMPTY = new CollectionEmptinessMatcher(false);

    public static Matcher<Collection> isEmpty() {
        return IS_EMPTY;
    }

    public static Matcher<Collection> isNotEmpty() {
        return IS_NOT_EMPTY;
    }

    public static Matcher<Collection<?>> hasSize(int size) {
        return Matchers.hasSize((int)size);
    }

    public static <X extends Collection<?>> HasNullElementsMatcher<X> hasNullElements() {
        return HasNullElementsMatcher.HAS_NULL_ELEMENTS_MATCHER;
    }

    public static <X extends Collection<?>> HasNullElementsMatcher<X> hasNoNullElements() {
        return HasNullElementsMatcher.HAS_NO_NULL_ELEMENTS_MATCHER;
    }

    public static <C extends Collection<?>> Matcher<C> isInitialized() {
        return InitializationCheckMatcher.isInitialized();
    }

    public static <C extends Collection<?>> Matcher<C> isNotInitialized() {
        return InitializationCheckMatcher.isNotInitialized();
    }
}

