/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.logger;

import java.util.Set;
import org.hibernate.testing.logger.LogInspectionHelper;
import org.hibernate.testing.logger.LogListener;
import org.hibernate.testing.logger.TriggerOnPrefixLogListener;
import org.hibernate.testing.logger.Triggerable;
import org.jboss.logging.BasicLogger;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class LoggerInspectionExtension
implements AfterEachCallback {
    private final BasicLogger log;

    public static LoggerInspectionRuleBuilder builder() {
        return new LoggerInspectionRuleBuilder();
    }

    public LoggerInspectionExtension(BasicLogger log) {
        this.log = log;
    }

    public void registerListener(LogListener listener) {
        LogInspectionHelper.registerListener(listener, this.log);
    }

    public Triggerable watchForLogMessages(String prefix) {
        TriggerOnPrefixLogListener listener = new TriggerOnPrefixLogListener(prefix);
        this.registerListener(listener);
        return listener;
    }

    public Triggerable watchForLogMessages(Set<String> prefixes) {
        TriggerOnPrefixLogListener listener = new TriggerOnPrefixLogListener(prefixes);
        this.registerListener(listener);
        return listener;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        LogInspectionHelper.clearAllListeners(this.log);
    }

    public static class LoggerInspectionRuleBuilder {
        BasicLogger log;

        public LoggerInspectionRuleBuilder setLogger(BasicLogger log) {
            this.log = log;
            return this;
        }

        public LoggerInspectionExtension build() {
            return new LoggerInspectionExtension(this.log);
        }
    }
}

