/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.internal.util.ReflectHelper;

public final class DialectContext {
    private static Dialect dialect;

    static void init() {
        Driver driver;
        Constructor constructor;
        Properties properties = Environment.getProperties();
        String diverClassName = properties.getProperty("hibernate.connection.driver_class");
        String dialectName = properties.getProperty("hibernate.dialect");
        String jdbcUrl = properties.getProperty("hibernate.connection.url");
        Properties props = new Properties();
        props.setProperty("user", properties.getProperty("hibernate.connection.username"));
        props.setProperty("password", properties.getProperty("hibernate.connection.password"));
        if (dialectName == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            Class dialectClass = ReflectHelper.classForName((String)dialectName);
            constructor = dialectClass.getConstructor(DialectResolutionInfo.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName, (Throwable)cnfe);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate given dialect class: " + dialectName, (Throwable)e);
        }
        try {
            driver = (Driver)Class.forName(diverClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("JDBC Driver class not found: " + dialectName, (Throwable)cnfe);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate given JDBC driver class: " + dialectName, (Throwable)e);
        }
        try (Connection connection = driver.connect(jdbcUrl, props);){
            dialect = (Dialect)constructor.newInstance(new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData()));
        }
        catch (SQLException sqle) {
            throw new JDBCConnectionException("Could not connect to database with JDBC URL: '" + jdbcUrl + "' [" + sqle.getMessage() + "]", sqle);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate given dialect class: " + dialectName, (Throwable)e);
        }
    }

    private DialectContext() {
    }

    public static synchronized Dialect getDialect() {
        if (dialect == null) {
            DialectContext.init();
        }
        return dialect;
    }
}

