/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.gambit;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Convert;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.testing.orm.domain.gambit.EnumValue;
import org.hibernate.testing.orm.domain.gambit.EnumValueConverter;
import org.hibernate.testing.orm.domain.gambit.SimpleComponent;
import org.hibernate.testing.orm.domain.gambit.SimpleEntity;

@Entity
public class EntityOfLists {
    private Integer id;
    private String name;
    private List<String> listOfBasics;
    private List<Double> listOfNumbers;
    private List<EnumValue> listOfConvertedEnums;
    private List<EnumValue> listOfEnums;
    private List<SimpleComponent> listOfComponents;
    private List<SimpleEntity> listOfOneToMany;
    private List<SimpleEntity> listOfManyToMany;

    public EntityOfLists() {
    }

    public EntityOfLists(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    @Id
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ElementCollection
    @OrderColumn
    @CollectionTable(name="EntityOfLists_basic")
    public List<String> getListOfBasics() {
        return this.listOfBasics;
    }

    public void setListOfBasics(List<String> listOfBasics) {
        this.listOfBasics = listOfBasics;
    }

    @ElementCollection
    @OrderColumn(name="num_indx")
    @CollectionTable(name="EntityOfLists_numbers")
    public List<Double> getListOfNumbers() {
        return this.listOfNumbers;
    }

    public void setListOfNumbers(List<Double> listOfNumbers) {
        this.listOfNumbers = listOfNumbers;
    }

    public void addBasic(String basic) {
        if (this.listOfBasics == null) {
            this.listOfBasics = new ArrayList<String>();
        }
        this.listOfBasics.add(basic);
    }

    public void addNumber(double number) {
        if (this.listOfNumbers == null) {
            this.listOfNumbers = new ArrayList<Double>();
        }
        this.listOfNumbers.add(number);
    }

    @ElementCollection
    @OrderColumn
    @Convert(converter=EnumValueConverter.class)
    @CollectionTable(name="EntityOfLists_enum1")
    public List<EnumValue> getListOfConvertedEnums() {
        return this.listOfConvertedEnums;
    }

    public void setListOfConvertedEnums(List<EnumValue> listOfConvertedEnums) {
        this.listOfConvertedEnums = listOfConvertedEnums;
    }

    public void addConvertedEnum(EnumValue value) {
        if (this.listOfConvertedEnums == null) {
            this.listOfConvertedEnums = new ArrayList<EnumValue>();
        }
        this.listOfConvertedEnums.add(value);
    }

    @ElementCollection
    @Enumerated(value=EnumType.STRING)
    @OrderColumn
    @CollectionTable(name="EntityOfLists_enum2")
    public List<EnumValue> getListOfEnums() {
        return this.listOfEnums;
    }

    public void setListOfEnums(List<EnumValue> listOfEnums) {
        this.listOfEnums = listOfEnums;
    }

    public void addEnum(EnumValue value) {
        if (this.listOfEnums == null) {
            this.listOfEnums = new ArrayList<EnumValue>();
        }
        this.listOfEnums.add(value);
    }

    @ElementCollection
    @OrderColumn
    @CollectionTable(name="EntityOfLists_comp")
    public List<SimpleComponent> getListOfComponents() {
        return this.listOfComponents;
    }

    public void setListOfComponents(List<SimpleComponent> listOfComponents) {
        this.listOfComponents = listOfComponents;
    }

    public void addComponent(SimpleComponent value) {
        if (this.listOfComponents == null) {
            this.listOfComponents = new ArrayList<SimpleComponent>();
        }
        this.listOfComponents.add(value);
    }

    @OneToMany
    @OrderColumn
    @CollectionTable(name="EntityOfLists_o2m")
    public List<SimpleEntity> getListOfOneToMany() {
        return this.listOfOneToMany;
    }

    public void setListOfOneToMany(List<SimpleEntity> listOfOneToMany) {
        this.listOfOneToMany = listOfOneToMany;
    }

    public void addOneToMany(SimpleEntity value) {
        if (this.listOfOneToMany == null) {
            this.listOfOneToMany = new ArrayList<SimpleEntity>();
        }
        this.listOfOneToMany.add(value);
    }

    @ManyToMany
    @OrderColumn
    @CollectionTable(name="EntityOfLists_m2m")
    public List<SimpleEntity> getListOfManyToMany() {
        return this.listOfManyToMany;
    }

    public void setListOfManyToMany(List<SimpleEntity> listOfManyToMany) {
        this.listOfManyToMany = listOfManyToMany;
    }

    public void addManyToMany(SimpleEntity value) {
        if (this.listOfManyToMany == null) {
            this.listOfManyToMany = new ArrayList<SimpleEntity>();
        }
        this.listOfManyToMany.add(value);
    }
}

