/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.env;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.internal.util.PropertiesHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.testing.DialectCheck;
import org.hibernate.testing.env.TestingDatabaseInfo;

public class ConnectionProviderBuilder
implements DialectCheck {
    public static final String DRIVER = "org.h2.Driver";
    public static final String DATA_SOURCE = "org.h2.jdbcx.JdbcDataSource";
    public static final String URL_FORMAT = "jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;LOCK_TIMEOUT=10000;DB_CLOSE_ON_EXIT=FALSE";
    public static final String URL = "jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;LOCK_TIMEOUT=10000;DB_CLOSE_ON_EXIT=FALSE";
    public static final String USER = "sa";
    public static final String PASS = "";

    public static Properties getConnectionProviderProperties(String dbName) {
        Properties props = new Properties(null);
        props.put("hibernate.connection.driver_class", DRIVER);
        props.put("hibernate.connection.url", String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;LOCK_TIMEOUT=10000;DB_CLOSE_ON_EXIT=FALSE", dbName));
        props.put("hibernate.connection.username", USER);
        props.put("hibernate.connection.password", PASS);
        props.put("hibernate.connection.init_sql", PASS);
        return props;
    }

    public static Properties getJpaConnectionProviderProperties(String dbName) {
        Properties props = new Properties(null);
        props.put("javax.persistence.jdbc.driver", DRIVER);
        props.put("javax.persistence.jdbc.url", String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;LOCK_TIMEOUT=10000;DB_CLOSE_ON_EXIT=FALSE", dbName));
        props.put("javax.persistence.jdbc.user", USER);
        props.put("javax.persistence.jdbc.password", PASS);
        props.put("hibernate.connection.init_sql", PASS);
        return props;
    }

    public static Properties getConnectionProviderProperties() {
        return ConnectionProviderBuilder.getConnectionProviderProperties("db1");
    }

    public static Properties getJpaConnectionProviderProperties() {
        return ConnectionProviderBuilder.getJpaConnectionProviderProperties("db1");
    }

    public static DriverManagerConnectionProviderImpl buildConnectionProvider() {
        return ConnectionProviderBuilder.buildConnectionProvider(false);
    }

    public static DriverManagerConnectionProviderImpl buildConnectionProvider(String dbName) {
        return ConnectionProviderBuilder.buildConnectionProvider(ConnectionProviderBuilder.getConnectionProviderProperties(dbName), false);
    }

    public static DatasourceConnectionProviderImpl buildDataSourceConnectionProvider(String dbName) {
        try {
            Class dataSourceClass = ReflectHelper.classForName((String)DATA_SOURCE, ConnectionProviderBuilder.class);
            DataSource actualDataSource = (DataSource)dataSourceClass.newInstance();
            ReflectHelper.findSetterMethod((Class)dataSourceClass, (String)"URL", String.class).invoke((Object)actualDataSource, String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;LOCK_TIMEOUT=10000;DB_CLOSE_ON_EXIT=FALSE", dbName));
            ReflectHelper.findSetterMethod((Class)dataSourceClass, (String)"user", String.class).invoke((Object)actualDataSource, USER);
            ReflectHelper.findSetterMethod((Class)dataSourceClass, (String)"password", String.class).invoke((Object)actualDataSource, PASS);
            final DataSourceInvocationHandler dataSourceInvocationHandler = new DataSourceInvocationHandler(actualDataSource);
            DatasourceConnectionProviderImpl connectionProvider = new DatasourceConnectionProviderImpl(){

                public void stop() {
                    dataSourceInvocationHandler.stop();
                }
            };
            connectionProvider.configure(Collections.singletonMap("hibernate.connection.datasource", Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)dataSourceInvocationHandler)));
            return connectionProvider;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static DriverManagerConnectionProviderImpl buildConnectionProvider(boolean allowAggressiveRelease) {
        return ConnectionProviderBuilder.buildConnectionProvider(ConnectionProviderBuilder.getConnectionProviderProperties("db1"), allowAggressiveRelease);
    }

    private static DriverManagerConnectionProviderImpl buildConnectionProvider(Properties props, final boolean allowAggressiveRelease) {
        DriverManagerConnectionProviderImpl connectionProvider = new DriverManagerConnectionProviderImpl(){

            public boolean supportsAggressiveRelease() {
                return allowAggressiveRelease;
            }
        };
        connectionProvider.configure(PropertiesHelper.map((Properties)props));
        return connectionProvider;
    }

    public static Dialect getCorrespondingDialect() {
        return TestingDatabaseInfo.DIALECT;
    }

    @Override
    public boolean isMatch(Dialect dialect) {
        return ConnectionProviderBuilder.getCorrespondingDialect().getClass().equals(dialect.getClass());
    }

    private static class DataSourceInvocationHandler
    implements InvocationHandler {
        private final DataSource target;
        private Connection actualConnection;
        private Connection connectionProxy;

        public DataSourceInvocationHandler(DataSource target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getConnection".equals(method.getName()) && this.actualConnection == null) {
                this.actualConnection = (Connection)method.invoke((Object)this.target, args);
                this.connectionProxy = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(this.actualConnection));
            }
            return this.connectionProxy;
        }

        public void stop() {
            try {
                this.actualConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        private static class ConnectionInvocationHandler
        implements InvocationHandler {
            private final Connection target;

            public ConnectionInvocationHandler(Connection target) {
                this.target = target;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("close".equals(method.getName())) {
                    return null;
                }
                return method.invoke((Object)this.target, args);
            }
        }
    }
}

