/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.userguide;

import jakarta.persistence.CascadeType;
import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityResult;
import jakarta.persistence.EnumType;
import jakarta.persistence.FieldResult;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.NamedNativeQueries;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.QueryHint;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.SqlResultSetMappings;
import jakarta.persistence.StoredProcedureParameter;
import jakarta.persistence.Version;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.testing.orm.domain.userguide.AddressType;
import org.hibernate.testing.orm.domain.userguide.PersonNames;
import org.hibernate.testing.orm.domain.userguide.Phone;

@NamedNativeQueries(value={@NamedNativeQuery(name="find_person_name", query="SELECT name FROM Person ", resultClass=String.class), @NamedNativeQuery(name="find_person_name_and_nickName", query="SELECT    name,    nickName FROM Person "), @NamedNativeQuery(name="find_person_name_and_nickName_dto", query="select    name,    nickName from Person ", resultSetMapping="name_and_nickName_dto"), @NamedNativeQuery(name="find_person_by_name", query="select    p.id AS \"id\",    p.name AS \"name\",    p.nickName AS \"nickName\",    p.address AS \"address\",    p.createdOn AS \"createdOn\",    p.version AS \"version\" from Person p where p.name LIKE :name", resultClass=Person.class), @NamedNativeQuery(name="find_person_with_phones_by_name", query="select    pr.id AS \"pr.id\",    pr.name AS \"pr.name\",    pr.nickName AS \"pr.nickName\",    pr.address AS \"pr.address\",    pr.createdOn AS \"pr.createdOn\",    pr.version AS \"pr.version\",    ph.id AS \"ph.id\",    ph.person_id AS \"ph.person_id\",    ph.phone_number AS \"ph.number\",    ph.phone_type AS \"ph.type\" from Person pr join Phone ph ON pr.id = ph.person_id where pr.name LIKE :name", resultSetMapping="person_with_phones")})
@SqlResultSetMappings(value={@SqlResultSetMapping(name="person_with_phones", entities={@EntityResult(entityClass=Person.class, fields={@FieldResult(name="id", column="pr.id"), @FieldResult(name="name", column="pr.name"), @FieldResult(name="nickName", column="pr.nickName"), @FieldResult(name="address", column="pr.address"), @FieldResult(name="createdOn", column="pr.createdOn"), @FieldResult(name="version", column="pr.version")}), @EntityResult(entityClass=Phone.class, fields={@FieldResult(name="id", column="ph.id"), @FieldResult(name="person", column="ph.person_id"), @FieldResult(name="number", column="ph.number"), @FieldResult(name="type", column="ph.type")})}), @SqlResultSetMapping(name="name_and_nickName_dto", classes={@ConstructorResult(targetClass=PersonNames.class, columns={@ColumnResult(name="name"), @ColumnResult(name="nickName")})})})
@NamedQueries(value={@NamedQuery(name="get_person_by_name", query="select p from Person p where name = :name"), @NamedQuery(name="get_read_only_person_by_name", query="select p from Person p where name = :name", hints={@QueryHint(name="org.hibernate.readOnly", value="true")}), @NamedQuery(name="delete_person", query="delete Person")})
@NamedStoredProcedureQuery(name="sp_person_phones", procedureName="sp_person_phones", parameters={@StoredProcedureParameter(name="personId", type=Long.class, mode=ParameterMode.IN), @StoredProcedureParameter(name="personPhones", type=Class.class, mode=ParameterMode.REF_CURSOR)})
@Entity
public class Person {
    @Id
    @GeneratedValue
    private Long id;
    private String name;
    private String nickName;
    private String address;
    private LocalDateTime createdOn;
    @OneToMany(mappedBy="person", cascade={CascadeType.ALL})
    @OrderColumn(name="order_id")
    private List<Phone> phones = new ArrayList<Phone>();
    @ElementCollection
    @MapKeyEnumerated(value=EnumType.STRING)
    private Map<AddressType, String> addresses = new HashMap<AddressType, String>();
    @Version
    private int version;

    public Person() {
    }

    public Person(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public LocalDateTime getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(LocalDateTime createdOn) {
        this.createdOn = createdOn;
    }

    public List<Phone> getPhones() {
        return this.phones;
    }

    public Map<AddressType, String> getAddresses() {
        return this.addresses;
    }

    public void addPhone(Phone phone) {
        this.phones.add(phone);
        phone.setPerson(this);
    }
}

