/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.util.List;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.testing.orm.junit.DialectContext;
import org.hibernate.testing.orm.junit.DialectFeatureCheck;
import org.hibernate.testing.orm.junit.RequiresDialect;
import org.hibernate.testing.orm.junit.RequiresDialectFeature;
import org.hibernate.testing.orm.junit.RequiresDialectFeatureGroup;
import org.hibernate.testing.orm.junit.RequiresDialects;
import org.hibernate.testing.orm.junit.SkipForDialect;
import org.hibernate.testing.orm.junit.SkipForDialectGroup;
import org.hibernate.testing.orm.junit.TestingUtil;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class DialectFilterExtension
implements ExecutionCondition {
    private static final Logger log = Logger.getLogger(DialectFilterExtension.class);

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Dialect dialect = this.getDialect(context);
        if (dialect == null) {
            throw new RuntimeException("#getDialect returned null");
        }
        log.debugf("Checking Dialect [%s] - context = %s", (Object)dialect, (Object)context.getDisplayName());
        List<RequiresDialect> effectiveRequiresDialects = TestingUtil.findEffectiveRepeatingAnnotation(context, RequiresDialect.class, RequiresDialects.class);
        if (!effectiveRequiresDialects.isEmpty()) {
            StringBuilder requiredDialects = new StringBuilder();
            for (RequiresDialect requiresDialect : effectiveRequiresDialects) {
                boolean versionsMatch;
                requiredDialects.append(requiresDialect.value());
                requiredDialects.append(" ");
                int matchingMajorVersion = requiresDialect.majorVersion();
                if (matchingMajorVersion >= 0) {
                    int matchingMinorVersion = requiresDialect.minorVersion();
                    int matchingMicroVersion = requiresDialect.microVersion();
                    requiredDialects.append(", version = ");
                    requiredDialects.append(this.matchingVersionString(matchingMajorVersion, matchingMinorVersion, matchingMicroVersion));
                    requiredDialects.append(" ");
                    versionsMatch = DialectFilterExtension.versionsMatch(matchingMajorVersion, matchingMinorVersion, matchingMicroVersion, dialect, requiresDialect.matchSubTypes());
                } else {
                    versionsMatch = true;
                }
                if (!requiresDialect.value().isInstance(dialect) || !versionsMatch || !requiresDialect.matchSubTypes() && !requiresDialect.value().equals(dialect.getClass())) continue;
                return this.evaluateSkipConditions(context, dialect, "Matched @RequiresDialect");
            }
            return ConditionEvaluationResult.disabled((String)String.format(Locale.ROOT, "Failed @RequiresDialect(dialect=%s) check - found %s version %s]", requiredDialects, dialect.getClass().getName(), dialect.getVersion()));
        }
        return this.evaluateSkipConditions(context, dialect, "Passed all @SkipForDialects");
    }

    private String matchingVersionString(int matchingMajorVersion, int matchingMinorVersion, int matchingMicroVersion) {
        StringBuilder buffer = new StringBuilder(matchingMajorVersion);
        if (matchingMajorVersion > 0) {
            buffer.append(".").append(matchingMinorVersion);
            if (matchingMicroVersion > 0) {
                buffer.append(".").append(matchingMicroVersion);
            }
        }
        return buffer.toString();
    }

    public static boolean versionsMatch(int matchingMajorVersion, int matchingMinorVersion, int matchingMicroVersion, Dialect dialect, boolean matchNewerVersions) {
        if (matchingMajorVersion < 0) {
            return false;
        }
        if (matchingMinorVersion < 0) {
            matchingMinorVersion = 0;
        }
        if (matchingMicroVersion < 0) {
            matchingMicroVersion = 0;
        }
        if (matchNewerVersions) {
            return dialect.getVersion().isSameOrAfter(matchingMajorVersion, matchingMinorVersion, matchingMicroVersion);
        }
        return dialect.getVersion().isSame(matchingMajorVersion);
    }

    private ConditionEvaluationResult evaluateSkipConditions(ExtensionContext context, Dialect dialect, String enabledResult) {
        List<SkipForDialect> effectiveSkips = TestingUtil.findEffectiveRepeatingAnnotation(context, SkipForDialect.class, SkipForDialectGroup.class);
        for (SkipForDialect effectiveSkipForDialect : effectiveSkips) {
            boolean versionsMatch;
            int matchingMajorVersion = effectiveSkipForDialect.majorVersion();
            if (!(matchingMajorVersion >= 0 ? (versionsMatch = DialectFilterExtension.versionsMatch(matchingMajorVersion, effectiveSkipForDialect.minorVersion(), effectiveSkipForDialect.microVersion(), dialect, effectiveSkipForDialect.matchSubTypes())) && (effectiveSkipForDialect.matchSubTypes() ? effectiveSkipForDialect.dialectClass().isInstance(dialect) : effectiveSkipForDialect.dialectClass().equals(dialect.getClass())) : (effectiveSkipForDialect.matchSubTypes() ? effectiveSkipForDialect.dialectClass().isInstance(dialect) : effectiveSkipForDialect.dialectClass().equals(dialect.getClass())))) continue;
            return ConditionEvaluationResult.disabled((String)"Matched @SkipForDialect");
        }
        List<RequiresDialectFeature> effectiveRequiresDialectFeatures = TestingUtil.findEffectiveRepeatingAnnotation(context, RequiresDialectFeature.class, RequiresDialectFeatureGroup.class);
        for (RequiresDialectFeature effectiveRequiresDialectFeature : effectiveRequiresDialectFeatures) {
            try {
                Class<? extends DialectFeatureCheck> featureClass = effectiveRequiresDialectFeature.feature();
                DialectFeatureCheck featureCheck = featureClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                boolean testResult = featureCheck.apply(dialect);
                if (effectiveRequiresDialectFeature.reverse()) {
                    boolean bl = testResult = !testResult;
                }
                if (testResult) continue;
                return ConditionEvaluationResult.disabled((String)String.format(Locale.ROOT, "Failed @RequiresDialectFeature [%s]", featureClass));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Unable to instantiate DialectFeatureCheck class", e);
            }
        }
        return ConditionEvaluationResult.enabled((String)enabledResult);
    }

    private Dialect getDialect(ExtensionContext context) {
        return DialectContext.getDialect();
    }
}

